<?php
/**
 * Sets internal properties on a subject object - used primarily to set state of immutable data objects
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 */

namespace spec\Support;


use PhpSpec\Wrapper\Subject;
use PhpSpec\Wrapper\SubjectContainerInterface;

/**
 * Sets protected fields on a specification subject, to set state for data objects and the like
 *
 * @package spec\Support
 */
class SubjectProtectedPropertySetter {

	/**
	 * @var object
	 */
	protected $object;

	/**
	 * @var \ReflectionClass
	 */
	protected $reflection;

	/**
	 * @param \PhpSpec\Wrapper\SubjectContainerInterface $subject
	 *
	 * @return static
	 */
	public static function for_subject(SubjectContainerInterface $subject)
	{
		return new static($subject->getWrappedObject());
	}

	/**
	 * @param object $object
	 */
	public function __construct($object)
	{
		$this->object = $object;
		$this->reflection = new \ReflectionClass($object);
	}

	/**
	 * @param mixed[] $fields
	 *
	 * @return void
	 */
	public function set_values($fields)
	{

		foreach ($fields as $field => $value)
		{
			$prop = $this->reflection->getProperty($field);
			$prop->setAccessible(TRUE);
			$prop->setValue($this->object, $value);
		}
	}
} 
