<?php
/**
 * Defines ViaCorePluginManagerSpec - specifications for Red61\Via\Plugin\ViaCorePluginManager
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\Plugin;

use PhpSpec\Exception\Example\FailureException;
use spec\ObjectBehavior;
use Prophecy\Argument;

/**
 *
 * @see Red61\Via\Plugin\ViaCorePluginManager
 */
class ViaCorePluginManagerSpec extends ObjectBehavior
{
    /**
     * Use $this->subject to get proper type hinting for the subject class
     * @var \Red61\Via\Plugin\ViaCorePluginManager
     */
	protected $subject;

	function it_is_initializable()
    {
		$this->subject->shouldHaveType('Red61\Via\Plugin\ViaCorePluginManager');
	}

	function it_is_a_via_plugin_manager()
	{
		$this->subject->shouldHaveType('Red61\Via\Plugin\ViaPluginManager');
	}

	function it_returns_array_of_registered_plugins()
	{
		$this->subject->getPluginDefinitions()->shouldBe(array());
	}

	/**
	 * @param \Red61\Via\Plugin\ViaPluginInterface $plugin
	 */
	function it_allows_plugins_to_register($plugin)
	{
		$this->subject->registerPlugin($plugin);
		$plugins = $this->subject->getPluginDefinitions();
		$plugins[0]['plugin']->shouldBe($plugin);
	}

	/**
	 * @param \Red61\Via\Plugin\ViaPluginInterface $plugin
	 */
	function it_allows_plugins_to_be_removed($plugin)
	{
		$this->subject->registerPlugin($plugin)
			->removePlugin($plugin)
			->getPluginDefinitions()->shouldBe(array());
	}

	/**
	 * @param \Red61\Via\Plugin\ViaPluginInterface $plugin
	 *
	 * @throws \PhpSpec\Exception\Example\FailureException
	 */
	function it_throws_if_removing_unregistered_plugin($plugin)
	{
		try {
			$this->subject->removePlugin($plugin);
			throw new FailureException("Expected exception not got");
		} catch (\InvalidArgumentException $e) {
			// OK
		}
	}

	/**
	 * @param \Red61\Via\Plugin\ViaPluginInterface    $plugin1
	 * @param \Red61\Via\Plugin\ViaPluginInterface    $plugin2
	 * @param \Red61\Via\Plugin\ViaPluginNotification $notification
	 */
	function it_notifies_registered_plugins_of_all_events_by_default($plugin1, $plugin2, $notification)
	{
		$this->subject->registerPlugin($plugin1)->registerPlugin($plugin2);

		$this->subject->notify($notification);

		$plugin1->onViaPluginNotification($notification)->shouldHaveBeenCalled();
		$plugin2->onViaPluginNotification($notification)->shouldHaveBeenCalled();
	}

	/**
 	 * @param \Red61\Via\Plugin\ViaPluginInterface    $plugin1
	 * @param \Red61\Via\Plugin\ViaPluginInterface    $plugin2
	 * @param \Red61\Via\Plugin\ViaPluginNotification $notification
	 */
	function it_notifies_plugins_of_events_they_register_for($plugin1, $plugin2, $notification)
	{
		$notification->getNotificationName()->willReturn('via.some-random-event');
		$this->subject->registerPlugin($plugin1, array('via.some-random-event'));
		$this->subject->registerPlugin($plugin2);

		$this->subject->notify($notification);
		$plugin1->onViaPluginNotification($notification)->shouldHaveBeenCalled();
		$plugin2->onViaPluginNotification($notification)->shouldHaveBeenCalled();
	}

	/**
 	 * @param \Red61\Via\Plugin\ViaPluginInterface    $plugin1
	 * @param \Red61\Via\Plugin\ViaPluginInterface    $plugin2
	 * @param \Red61\Via\Plugin\ViaPluginNotification $notification
	 */
	function it_does_not_notify_plugins_of_events_they_do_not_register_for($plugin1, $plugin2, $notification)
	{
		$notification->getNotificationName()->willReturn('via.boring-event');
		$this->subject->registerPlugin($plugin1, array('via.some-random-event'));
		$this->subject->registerPlugin($plugin2);

		$this->subject->notify($notification);
		$plugin1->onViaPluginNotification($notification)->shouldNotHaveBeenCalled();
		$plugin2->onViaPluginNotification($notification)->shouldHaveBeenCalled();
	}


}
