<?php
/**
 * Defines the RawViaApiOrderFailException base exception class
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\Exception;

use \Red61\Via\Exception\ViaException;

/**
 * An exception indicating that there was an error in the order process.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\Exception\ViaApiOrderFailException.
 *
 * @package    Red61\Via\RawGenerated\Exception
 * @see        \Red61\Via\Exception\ViaApiOrderFailException.
 */
abstract class RawViaApiOrderFailException extends \SoapFault implements ViaException {

  /**
   * 
   *
   * @var mixed
   */
  protected $viacode;


  public static function fromSoapFault(\SoapFault $fault)
  {
    $e = new static(
        $fault->faultcode,
        $fault->faultstring,
        $fault->faultactor,
        $fault->detail
    );
    if (isset($fault->detail->ViaApiOrderFailException->code)) {
      $e->viacode = $fault->detail->ViaApiOrderFailException->code;
    }

    return $e;
  }

  /**
   * 
   *
   * @return mixed
   */
  public function getViacode()
  {
    return $this->viacode;
  }


}
