<?php
/**
 * Defines the apiGetPerformanceDetailsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\ApiRequest;
use Red61\Via\Exception\ClientInvalidRequestException;
use Red61\Via\Plugin\ViaApiCallNotification;

/**
 * @package    Red61\Via\ApiRequest
 * {@inheritdoc}
 */
class apiGetPerformanceDetailsRequest extends \Red61\Via\RawGenerated\ApiRequest\RawapiGetPerformanceDetailsRequest
	implements PreflightFilteringRequest {

	/**
	 * {@inheritdoc}
	 */
	public function onBeforeViaCall(ViaApiCallNotification $notification)
	{
		if ($errors = $this->buildEmptyFieldErrorsFor(array('performanceRef'))) {
			throw new ClientInvalidRequestException($this, $errors);
		}
	}

}
