<?php
/**
 * Defines the RawapiUpdateCustomerAccessRequirementRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Updates the customers access requirements
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiUpdateCustomerAccessRequirementRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiUpdateCustomerAccessRequirementRequest.
 */
abstract class RawapiUpdateCustomerAccessRequirementRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiUpdateCustomerAccessRequirement';

  /**
   * The id of the customer to set the access requirements for.
   *
   * @var int
   */
  protected $customerId;

  /**
   * The access requirements to set.
   *
   * @var string
   */
  protected $accessRequirement;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The id of the customer to set the access requirements for.
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The id of the customer to set the access requirements for.
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The access requirements to set.
   *
   * @return string
   */
  public function getAccessRequirement()
  {
    return $this->accessRequirement;
  }


  /**
   * The access requirements to set.
   *
   * @param string $accessRequirement
   *
   * @return $this
   */
  public function setAccessRequirement($accessRequirement)
  {
    $this->accessRequirement = $accessRequirement;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
