<?php
/**
 * Defines the RawapiSubmitAccreditationRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Method submits an accreditation for a customer. If the ‘draft’ parameter is set to true, the accreditation should
 * be created with a status of ‘INCOMPLETE’ and it should skip the validation of the questionnaire response.
 * Otherwise, the accreditation should be created with a status of ‘PENDING’ and questionnaire validation should
 * occur as usual.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiSubmitAccreditationRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiSubmitAccreditationRequest.
 */
abstract class RawapiSubmitAccreditationRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiSubmitAccreditation';

  /**
   * - the Id of the accreditation type of which you want to create an instance
   *
   * @var int
   */
  protected $accreditationTypeId;

  /**
   * - the ID of the customer for which you are creating the accreditation
   *
   * @var int
   */
  protected $customerId;

  /**
   * - if set to true, the resulting accreditation will be given a status of ‘INCOMPLETE’. Otherwise, it will be set
   * to ‘PENDING’.
   *
   * @var bool
   */
  protected $draft;

  /**
   * - the answers to the questionnaire associated with the accreditation type
   *
   * @var \Red61\Via\DataObject\ViaApiQuestionResponse[]
   */
  protected $responses;

  /**
   * - the authentication code to use
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * - the Id of the accreditation type of which you want to create an instance
   *
   * @return int
   */
  public function getAccreditationTypeId()
  {
    return $this->accreditationTypeId;
  }


  /**
   * - the Id of the accreditation type of which you want to create an instance
   *
   * @param int $accreditationTypeId
   *
   * @return $this
   */
  public function setAccreditationTypeId($accreditationTypeId)
  {
    $this->accreditationTypeId = $accreditationTypeId;
    return $this;
  }

  /**
   * - the ID of the customer for which you are creating the accreditation
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * - the ID of the customer for which you are creating the accreditation
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * - if set to true, the resulting accreditation will be given a status of ‘INCOMPLETE’. Otherwise, it will be set
   * to ‘PENDING’.
   *
   * @return bool
   */
  public function getDraft()
  {
    return $this->draft;
  }


  /**
   * - if set to true, the resulting accreditation will be given a status of ‘INCOMPLETE’. Otherwise, it will be set
   * to ‘PENDING’.
   *
   * @param bool $draft
   *
   * @return $this
   */
  public function setDraft($draft)
  {
    $this->draft = $draft;
    return $this;
  }

  /**
   * - the answers to the questionnaire associated with the accreditation type
   *
   * @return \Red61\Via\DataObject\ViaApiQuestionResponse[]
   */
  public function getResponses()
  {
    return $this->responses;
  }


  /**
   * - the answers to the questionnaire associated with the accreditation type
   *
   * @param \Red61\Via\DataObject\ViaApiQuestionResponse[] $responses
   *
   * @return $this
   */
  public function setResponses($responses)
  {
    $this->responses = $responses;
    return $this;
  }

  /**
   * - the authentication code to use
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * - the authentication code to use
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
