<?php
/**
 * Defines ViaCacheDriver
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\Cache;

/**
 * A VIA cache driver handles lookup, storage and flush of the VIA cache as directed by the ViaCachePlugin
 *
 * [!!] If your application operates across multiple nodes, you **MUST** use a central cache backend. The
 *      use of distributed per-instance caching is not supported and will produce unexpected results.
 *
 * @package Red61\Via\Cache
 */
interface ViaCacheDriver {

	/**
	 * Fetch a response from cache, if available.
	 *
	 * @param string $namespace used to group similar responses in the cache
	 * @param string $key       unique key for the current request parameters
	 * @param int    $ttl       maximum age in seconds of response to return
	 *
	 * @return mixed the cached value, or NULL
	 */
	public function lookup($namespace, $key, $ttl);

	/**
	 * Store a response in the cache
	 *
	 * @param string $namespace used to group similar responses in the cache
	 * @param string $key       unique key for the current request parameters
	 * @param mixed  $value     response value to store
	 * @param int    $ttl       maximum age in seconds before this response should be discarded
	 *
	 * @return void
	 */
	public function store($namespace, $key, $value, $ttl);

	/**
	 * Flush the VIA-related items from the cache
	 *
	 * @return void
	 */
	public function flush();

} 
