<?php
/**
 * Defines the apiGetBasketSuggestedDonationsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\ApiRequest;
use Red61\Via\Plugin\ViaApiCallNotification;

/**
 * @package    Red61\Via\ApiRequest
 * {@inheritdoc}
 */
class apiGetBasketSuggestedDonationsRequest
	extends \Red61\Via\RawGenerated\ApiRequest\RawapiGetBasketSuggestedDonationsRequest
	implements PreflightFilteringRequest {

	/**
	 * Sets a canned empty array response if the basket ID has not yet been set
	 * {@inheritdoc}
	 */
	public function onBeforeViaCall(ViaApiCallNotification $notification)
	{
		if ( ! $this->getSessionId()) {
			$notification->skipCallAndReturn(array());
		}
	}

}
