<?php
/**
 * Defines the RawapiGetBasketSuggestedDonationsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Returns a list of the suggested donations for this basket with `ViaApiDonationFund#amount` set to the suggested
 * amount.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetBasketSuggestedDonationsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetBasketSuggestedDonationsRequest.
 */
abstract class RawapiGetBasketSuggestedDonationsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiGetBasketSuggestedDonations';

  /**
   * The filter options are the following:
   * 
   * - Display event linked donation funds only.
   * - Display event unlinked donation funds only.
   * - Display both linked and unlinked donation funds.
   * 
   * Note: An unlinked donation fund is a donation fund that does not link to any events.
   *
   * @var int
   */
  protected $filterOption;

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The filter options are the following:
   * 
   * - Display event linked donation funds only.
   * - Display event unlinked donation funds only.
   * - Display both linked and unlinked donation funds.
   * 
   * Note: An unlinked donation fund is a donation fund that does not link to any events.
   *
   * @return int
   */
  public function getFilterOption()
  {
    return $this->filterOption;
  }


  /**
   * The filter options are the following:
   * 
   * - Display event linked donation funds only.
   * - Display event unlinked donation funds only.
   * - Display both linked and unlinked donation funds.
   * 
   * Note: An unlinked donation fund is a donation fund that does not link to any events.
   *
   * @param int $filterOption
   *
   * @return $this
   */
  public function setFilterOption($filterOption)
  {
    $this->filterOption = $filterOption;
    return $this;
  }

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
