<?php
/**
 * Defines the RawapiCheckPasswordResetTokenValidityRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Method checks if the customer password reset token is valid and has not expired
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiCheckPasswordResetTokenValidityRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiCheckPasswordResetTokenValidityRequest.
 */
abstract class RawapiCheckPasswordResetTokenValidityRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiCheckPasswordResetTokenValidity';

  /**
   * - generated password reset token
   *
   * @var string
   */
  protected $token;

  /**
   * - The authentication code
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * - generated password reset token
   *
   * @return string
   */
  public function getToken()
  {
    return $this->token;
  }


  /**
   * - generated password reset token
   *
   * @param string $token
   *
   * @return $this
   */
  public function setToken($token)
  {
    $this->token = $token;
    return $this;
  }

  /**
   * - The authentication code
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * - The authentication code
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
