<?php
/**
 * Defines the RawapiReleaseTicketsFromReservationRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Releases tickets within a reservation. If the `itemIds` List is empty or `null` the system will release all remaining
 * active tickets within the reservation. An active ticket is one that has not been released or already converted.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiReleaseTicketsFromReservationRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiReleaseTicketsFromReservationRequest.
 */
abstract class RawapiReleaseTicketsFromReservationRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiReleaseTicketsFromReservation';

  /**
   * The order ID of the reservation in the form 'serverId:orderId'. See `ViaApiPurchaseSummary#orderid`
   * `ViaApiTransactionDetails#orderid`
   *
   * @var string
   */
  protected $orderId;

  /**
   * A list of the item Ids, `ViaApiTicketItemDetails#itemId`s or `ViaApiTicketItemDetailsWithStatus#itemId`s, of the
   * active tickets within this reservation to be released. If the field `ViaApiTicketItemDetails#reservationStatus` or
   * `ViaApiTicketItemDetailsWithStatus#reservationStatus` is **`Pending`** then the ticket is active at the time of
   * loading. See `ViaApiPurchaseSummary#products` or `ViaApiTransactionDetails#products` for grouped tickets within the
   * reservation, then `ViaApiTicketDetails#ticketItems` or `ViaApiTicketDetailsWithStatus#ticketItems` for individual
   * tickets. If `null` or empty all remaining active tickets within this reservation will be released.
   *
   * @var int[]
   */
  protected $itemIds;

  /**
   * An optional String with the reason for releasing the tickets from the reservation.
   *
   * @var string
   */
  protected $releaseNote;

  /**
   * The authentication code
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The order ID of the reservation in the form 'serverId:orderId'. See `ViaApiPurchaseSummary#orderid`
   * `ViaApiTransactionDetails#orderid`
   *
   * @return string
   */
  public function getOrderId()
  {
    return $this->orderId;
  }


  /**
   * The order ID of the reservation in the form 'serverId:orderId'. See `ViaApiPurchaseSummary#orderid`
   * `ViaApiTransactionDetails#orderid`
   *
   * @param string $orderId
   *
   * @return $this
   */
  public function setOrderId($orderId)
  {
    $this->orderId = $orderId;
    return $this;
  }

  /**
   * A list of the item Ids, `ViaApiTicketItemDetails#itemId`s or `ViaApiTicketItemDetailsWithStatus#itemId`s, of the
   * active tickets within this reservation to be released. If the field `ViaApiTicketItemDetails#reservationStatus` or
   * `ViaApiTicketItemDetailsWithStatus#reservationStatus` is **`Pending`** then the ticket is active at the time of
   * loading. See `ViaApiPurchaseSummary#products` or `ViaApiTransactionDetails#products` for grouped tickets within the
   * reservation, then `ViaApiTicketDetails#ticketItems` or `ViaApiTicketDetailsWithStatus#ticketItems` for individual
   * tickets. If `null` or empty all remaining active tickets within this reservation will be released.
   *
   * @return int[]
   */
  public function getItemIds()
  {
    return $this->itemIds;
  }


  /**
   * A list of the item Ids, `ViaApiTicketItemDetails#itemId`s or `ViaApiTicketItemDetailsWithStatus#itemId`s, of the
   * active tickets within this reservation to be released. If the field `ViaApiTicketItemDetails#reservationStatus` or
   * `ViaApiTicketItemDetailsWithStatus#reservationStatus` is **`Pending`** then the ticket is active at the time of
   * loading. See `ViaApiPurchaseSummary#products` or `ViaApiTransactionDetails#products` for grouped tickets within the
   * reservation, then `ViaApiTicketDetails#ticketItems` or `ViaApiTicketDetailsWithStatus#ticketItems` for individual
   * tickets. If `null` or empty all remaining active tickets within this reservation will be released.
   *
   * @param int[] $itemIds
   *
   * @return $this
   */
  public function setItemIds($itemIds)
  {
    $this->itemIds = $itemIds;
    return $this;
  }

  /**
   * An optional String with the reason for releasing the tickets from the reservation.
   *
   * @return string
   */
  public function getReleaseNote()
  {
    return $this->releaseNote;
  }


  /**
   * An optional String with the reason for releasing the tickets from the reservation.
   *
   * @param string $releaseNote
   *
   * @return $this
   */
  public function setReleaseNote($releaseNote)
  {
    $this->releaseNote = $releaseNote;
    return $this;
  }

  /**
   * The authentication code
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
