<?php
/**
 * Defines the RawapiGetDonationFundRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Method Fetches the information for the fund for the specified reference This method will attempt translation of it's
 * returned objects, where available.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetDonationFundRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetDonationFundRequest.
 */
abstract class RawapiGetDonationFundRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetDonationFund';

  /**
   * reference of the donation fund to fetch. In the form `serverId:fundId`
   *
   * @var string
   */
  protected $donationFundRef;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * reference of the donation fund to fetch. In the form `serverId:fundId`
   *
   * @return string
   */
  public function getDonationFundRef()
  {
    return $this->donationFundRef;
  }


  /**
   * reference of the donation fund to fetch. In the form `serverId:fundId`
   *
   * @param string $donationFundRef
   *
   * @return $this
   */
  public function setDonationFundRef($donationFundRef)
  {
    $this->donationFundRef = $donationFundRef;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
