<?php
/**
 * Defines the RawapiGetCustomerJWTRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Create a customerJWT to "sudo" to this customer within the REST API
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetCustomerJWTRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetCustomerJWTRequest.
 */
abstract class RawapiGetCustomerJWTRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetCustomerJWT';

  /**
   * 
   *
   * @var int
   */
  protected $customerId;

  /**
   * The number of minutes for which the customer JWT should remain valid.
   *
   * @var int
   */
  protected $jwtExpiryMins;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * 
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * 
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The number of minutes for which the customer JWT should remain valid.
   *
   * @return int
   */
  public function getJwtExpiryMins()
  {
    return $this->jwtExpiryMins;
  }


  /**
   * The number of minutes for which the customer JWT should remain valid.
   *
   * @param int $jwtExpiryMins
   *
   * @return $this
   */
  public function setJwtExpiryMins($jwtExpiryMins)
  {
    $this->jwtExpiryMins = $jwtExpiryMins;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
