<?php
/**
 * Defines the RawViaApiQuestionnaireQuestion data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores information on the questionnaire question
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiQuestionnaireQuestion.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiQuestionnaireQuestion.
 */
#[\AllowDynamicProperties]
abstract class RawViaApiQuestionnaireQuestion {

  /**
   * The ID of this question .
   *
   * @var int
   */
  protected $questionId;

  /**
   * The question text.
   *
   * @var string
   */
  protected $question;

  /**
   * Whether or not the question is required in order to submit the questionnaire response.
   *
   * @var bool
   */
  protected $required;

  /**
   * A pre-populated text answer to the question if the question can support text answers.
   *
   * @var string
   */
  protected $response;

  /**
   * A pre-populated array of option IDs if the question has options.
   *
   * @var int[]
   */
  protected $selected;

  /**
   * The question type. Must be one of the following: TEXT_AREA, DROPDOWN, CHECKBOXES, NUMBER, INPUT, EMAIL, PHONE, URL,
   * RADIO_BUTTONS, DATE, IMAGE, TERMS_AND_CONDITIONS
   *
   * @var string
   */
  protected $type;

  /**
   * The list of options for the question in the case that it is multiple choice.
   *
   * @var \Red61\Via\DataObject\ViaApiQuestionnaireQuestionOption[]
   */
  protected $options;

  /**
   * The ID of the option that corresponds to answering ‘All’ for multiple choice questions.
   *
   * @var int
   */
  protected $allAnswer;

  /**
   * The ID of the option that corresponds to answering ‘None’ for multiple choice questions.
   *
   * @var int
   */
  protected $noneAnswer;

  /**
   * The ID of the option which will allow the user to supply a text answer in addition to their selected options for
   * multiple choice questions.
   *
   * @var int
   */
  protected $optionalAnswer;

  /**
   * The minimum value for date and numeric questions.
   *
   * @var string
   */
  protected $min;

  /**
   * The maximum value for date and numeric questions.
   *
   * @var string
   */
  protected $max;

  /**
   * The ID of the option within multiple choice questions which when selected will skip any nested questions.
   *
   * @var int
   */
  protected $skipAnswer;

  /**
   * Any subsequent questions that should be asked in the event that any answer bar the skip answer is selected for
   * multiple choice questions.
   *
   * @var \Red61\Via\DataObject\ViaApiQuestionnaireBasicQuestion[]
   */
  protected $nestedQuestions;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'questionId':
        return $this->getQuestionId();
      case 'question':
        return $this->getQuestion();
      case 'required':
        return $this->getRequired();
      case 'response':
        return $this->getResponse();
      case 'selected':
        return $this->getSelected();
      case 'type':
        return $this->getType();
      case 'options':
        return $this->getOptions();
      case 'allAnswer':
        return $this->getAllAnswer();
      case 'noneAnswer':
        return $this->getNoneAnswer();
      case 'optionalAnswer':
        return $this->getOptionalAnswer();
      case 'min':
        return $this->getMin();
      case 'max':
        return $this->getMax();
      case 'skipAnswer':
        return $this->getSkipAnswer();
      case 'nestedQuestions':
        return $this->getNestedQuestions();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The ID of this question .
   *
   * @return int
   */
  public function getQuestionId()
  {
    return $this->questionId;
  }


  /**
   * The question text.
   *
   * @return string
   */
  public function getQuestion()
  {
    return $this->question;
  }


  /**
   * Whether or not the question is required in order to submit the questionnaire response.
   *
   * @return bool
   */
  public function getRequired()
  {
    return $this->required;
  }


  /**
   * A pre-populated text answer to the question if the question can support text answers.
   *
   * @return string
   */
  public function getResponse()
  {
    return $this->response;
  }


  /**
   * A pre-populated array of option IDs if the question has options.
   *
   * @return int[]
   */
  public function getSelected()
  {
	return $this->selected ? : array();
  }


  /**
   * The question type. Must be one of the following: TEXT_AREA, DROPDOWN, CHECKBOXES, NUMBER, INPUT, EMAIL, PHONE, URL,
   * RADIO_BUTTONS, DATE, IMAGE, TERMS_AND_CONDITIONS
   *
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }


  /**
   * The list of options for the question in the case that it is multiple choice.
   *
   * @return \Red61\Via\DataObject\ViaApiQuestionnaireQuestionOption[]
   */
  public function getOptions()
  {
	return $this->options ? : array();
  }


  /**
   * The ID of the option that corresponds to answering ‘All’ for multiple choice questions.
   *
   * @return int
   */
  public function getAllAnswer()
  {
    return $this->allAnswer;
  }


  /**
   * The ID of the option that corresponds to answering ‘None’ for multiple choice questions.
   *
   * @return int
   */
  public function getNoneAnswer()
  {
    return $this->noneAnswer;
  }


  /**
   * The ID of the option which will allow the user to supply a text answer in addition to their selected options for
   * multiple choice questions.
   *
   * @return int
   */
  public function getOptionalAnswer()
  {
    return $this->optionalAnswer;
  }


  /**
   * The minimum value for date and numeric questions.
   *
   * @return string
   */
  public function getMin()
  {
    return $this->min;
  }


  /**
   * The maximum value for date and numeric questions.
   *
   * @return string
   */
  public function getMax()
  {
    return $this->max;
  }


  /**
   * The ID of the option within multiple choice questions which when selected will skip any nested questions.
   *
   * @return int
   */
  public function getSkipAnswer()
  {
    return $this->skipAnswer;
  }


  /**
   * Any subsequent questions that should be asked in the event that any answer bar the skip answer is selected for
   * multiple choice questions.
   *
   * @return \Red61\Via\DataObject\ViaApiQuestionnaireBasicQuestion[]
   */
  public function getNestedQuestions()
  {
	return $this->nestedQuestions ? : array();
  }


}
