<?php
/**
 * Defines the RawapiGetPaymentPageHashRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method is for fetching the relevant hash needed to interact with the red61 pay page. The type of hash needed is
 * defined by the `flowIdentifier`. The `customerSavedCardReference` is only needed for `flowIdentifier` **4**. The
 * `sessionId` is not needed for the save card flow.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetPaymentPageHashRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetPaymentPageHashRequest.
 */
abstract class RawapiGetPaymentPageHashRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiGetPaymentPageHash';

  /**
   * The ID of the specific flow through the pay page. The values supported are:
   * 
   * - The reservation payment link flow
   * - The pay by card / saved card flow
   * - The save card flow
   * - The cv2 capture flow
   *
   * @var int
   */
  protected $flowIdentifier;

  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * The customer ID for the basket
   *
   * @var int
   */
  protected $customerId;

  /**
   * The customer's saved card reference. See `ViaApiSavedCardDetails#id` field returned from `apiGetCustomerSavedCards`
   *
   * @var string
   */
  protected $customerSavedCardReference;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The ID of the specific flow through the pay page. The values supported are:
   * 
   * - The reservation payment link flow
   * - The pay by card / saved card flow
   * - The save card flow
   * - The cv2 capture flow
   *
   * @return int
   */
  public function getFlowIdentifier()
  {
    return $this->flowIdentifier;
  }


  /**
   * The ID of the specific flow through the pay page. The values supported are:
   * 
   * - The reservation payment link flow
   * - The pay by card / saved card flow
   * - The save card flow
   * - The cv2 capture flow
   *
   * @param int $flowIdentifier
   *
   * @return $this
   */
  public function setFlowIdentifier($flowIdentifier)
  {
    $this->flowIdentifier = $flowIdentifier;
    return $this;
  }

  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * The customer ID for the basket
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The customer ID for the basket
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The customer's saved card reference. See `ViaApiSavedCardDetails#id` field returned from `apiGetCustomerSavedCards`
   *
   * @return string
   */
  public function getCustomerSavedCardReference()
  {
    return $this->customerSavedCardReference;
  }


  /**
   * The customer's saved card reference. See `ViaApiSavedCardDetails#id` field returned from `apiGetCustomerSavedCards`
   *
   * @param string $customerSavedCardReference
   *
   * @return $this
   */
  public function setCustomerSavedCardReference($customerSavedCardReference)
  {
    $this->customerSavedCardReference = $customerSavedCardReference;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
