<?php
/**
 * Defines the RawapiGetCustomersSavedCardReferenceRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method is for fetching the customer's saved card reference from the supplied hash `paymentPageHash` for the cv2
 * capture flow (flow 4).
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetCustomersSavedCardReferenceRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetCustomersSavedCardReferenceRequest.
 */
abstract class RawapiGetCustomersSavedCardReferenceRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiGetCustomersSavedCardReference';

  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * The customer ID for the basket
   *
   * @var int
   */
  protected $customerId;

  /**
   * The hash for the customer's saved card. To generate this hash see {@link apiGetPaymentPageHash
   *
   * @var string
   */
  protected $paymentPageHash;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * The customer ID for the basket
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The customer ID for the basket
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The hash for the customer's saved card. To generate this hash see {@link apiGetPaymentPageHash
   *
   * @return string
   */
  public function getPaymentPageHash()
  {
    return $this->paymentPageHash;
  }


  /**
   * The hash for the customer's saved card. To generate this hash see {@link apiGetPaymentPageHash
   *
   * @param string $paymentPageHash
   *
   * @return $this
   */
  public function setPaymentPageHash($paymentPageHash)
  {
    $this->paymentPageHash = $paymentPageHash;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
