<?php
/**
 * Defines the apiGetSeatingPlanRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\ApiRequest;

/**
 * @package    Red61\Via\ApiRequest
 * {@inheritdoc}
 */
class apiGetSeatingPlanRequest
	extends \Red61\Via\RawGenerated\ApiRequest\RawapiGetSeatingPlanRequest
	implements CacheTTLOverridingRequest {

	/**
	 * Return the cache TTL that should be used for this request, in seconds
	 *
	 * @return int
	 */
	public function getCacheTtl()
	{
		if ($this->getLastUpdate() > 0) {
			// we want to check for plan updates ever 5 seconds
			return 5;
		} else {
			// this is the first load of the plan, so return anything from the last 5 mins, the delta update will bring it up to date
			return 300;
		}
	}

}
