<?php
/**
 * Defines the RawapiGetOrderTicketDetailsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Gets details about the tickets in a given order. This method will attempt translation of it's returned objects, where
 * available.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetOrderTicketDetailsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetOrderTicketDetailsRequest.
 */
abstract class RawapiGetOrderTicketDetailsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetOrderTicketDetails';

  /**
   * 'serverId:orderId' of the order to lookup tickets for.
   *
   * @var string
   */
  protected $orderId;

  /**
   * the authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * 'serverId:orderId' of the order to lookup tickets for.
   *
   * @return string
   */
  public function getOrderId()
  {
    return $this->orderId;
  }


  /**
   * 'serverId:orderId' of the order to lookup tickets for.
   *
   * @param string $orderId
   *
   * @return $this
   */
  public function setOrderId($orderId)
  {
    $this->orderId = $orderId;
    return $this;
  }

  /**
   * the authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * the authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
