<?php

function displayPerfCalendars($via,$performances)
{
	if(empty($performances)) {
		print "No Performances\n";
	}
	else {
		$prices = getGroupedPrices($via,$performances);
		foreach($via->groupPerformancesByDate($performances) as $perfs_month) {
			_renderCalendar($perfs_month,$prices);
		}
	}
}

function getGroupedPrices($via,$performances,$conc_code="CO")
{
	$prices = array();
	if(!is_array($performances)){
		$performances = array();
	}
	foreach($performances as $perf) {
		$pc_desc = "";
		if(isset($perf->concessions)) {
			$concessionTitles = array();
			foreach($perf->concessions as $concession){
				$concessionTitles[] = $concession->title;
			}
			$pc_title = implode($concessionTitles,", ");
			$key = $perf->maxfullprice . ", " . $pc_title;
		}else {
			$key = $perf->maxfullprice;
			$pc_title = "";
		}
		if(!isset($prices[$key])) {
			$perfprices = $via->getPerformancePrices($perf->id);
			$fullprice = null;
			$concession = null;
			foreach($perfprices as $price) {
				if(($fullprice == null)||($price->price < $fullprice)) {
					$fullprice = $price->price;
					if(isset($price->concessions)){
						if(!is_array($price->concessions)) $price->concessions = array($price->concessions);
						foreach($price->concessions as $conc) {
							if(isset($conc->code) && ($conc->code == $conc_code)) {
								$concession = $conc->concPrice;
							}
						}
					}
				}
			}
			$prices[$key] = array('fp'=>$fullprice,'conc'=>$concession,'pc'=>$pc_title,'pc_desc'=>$pc_desc);
		}
	}
	return($prices);
}

function displayPriceKey($via,$performances,$conc_code="CO")
{
	global $price_colours, $currency_h;
	$prices = getGroupedPrices($via,$performances,$conc_code);
	print "<table>";
	$i = 0;
	foreach($prices as $price) {
		print "<tr><td style=\"background: ".$price_colours[$i].";\">&nbsp;</td>";
		print "<td>$currency_h &nbsp;" . $price['fp'];
		if($price['conc']) print "&nbsp;($currency_h&nbsp;" . $price['conc'].")";
		if($price['pc']) {
			print "&nbsp;" . $price['pc'];
		}
		print "</td></tr>";
		$i++;
	}
	print "</table>";
}

function _renderCalendar($performances,$prices)
{
	global $price_colours;
	//print_r($performances);
	$days = array("Mon","Tue","Wed","Thu","Fri","Sat","Sun");
	// timestamp of first performance of first day
	$first_perf = strtotime($performances[array_shift(array_keys($performances))][0]->datetime) - (6 * 60 * 60);
	// timestamp of first performance of last day
	$last_perf = strtotime($performances[array_pop(array_keys($performances))][0]->datetime)- (6 * 60 * 60) +1;

	print "<p>" . date("F",$first_perf) . "</p>\n";
	print '<div>';
	print "<table id=\"perfdateblock\">\n";
	print "<tr><th>" . implode("</th><th>",$days) . "</th></tr>\n";
	$days = array_flip($days);
	print "<tr>\n";
	$d = 0;
	// pad starting days to get to the right day of the week
	for($i=0;$i < $days[date("D",$first_perf)]; $i++) {
		print "\t<td>&nbsp;</td>\n";
		$d++;
	}
	$day=strtotime(date("Y-m-d 00:00:01",$first_perf));
	while($day <= $last_perf) {
		$day_index=date("d",$day);
		#print_r($perf);
		if(isset($performances[$day_index])) {
			if(count($performances[$day_index]) > 1) {
				print "\t<td>";
				print date("j",$day) . "<br>\n";
				foreach($performances[$day_index] as $perf) {
					print "<div style=\"background: ".getPriceColorFromPerf($perf,$prices).";\"><a href='listprices.php?performanceId=$perf->id' title='$perf->title'>" . date('H:i',strtotime($perf->datetime)) . "</div></a>\n";
				}
			}
			else {
				$perf = $performances[$day_index][0];
				print "\t<td style=\"background: ".getPriceColorFromPerf($perf,$prices).";\"><a href='listprices.php?performanceId=$perf->id' title='$perf->title ". date('H:i',strtotime($perf->datetime)) . "'>" . date("j",$day) . "</a>\n";
			}
		}
		else {
			print "\t<td class='noshow'>&nbsp;";
		}
		print "</td>\n";
		$d++;
		if($d > 6) {
			print "</tr>\n<tr>";
			$d=0;
		}
		$day = strtotime("+1 day", $day);
	}
	// pad starting days to get to end the week
	if($d != 0) {
		for($i=$d;$i <= 6; $i++) {
			print "\t<td>&nbsp;</td>\n";
			$d++;
		}
	}
	print "</tr>\n";
	print "</table></div>\n";
}

function getPriceColorFromPerf($perf,$prices)
{
	global $price_colours;
	if(isset($perf->concessions)) {
		$titles = array();
		foreach($perf->concessions as $concession){
			$titles[] = $concession->title;
		}
		$key = $perf->maxfullprice . ", " . implode($titles,", ");
	}
	else {
		$key = $perf->maxfullprice;
	}
	return($price_colours[array_search($key,array_keys($prices))]);
}

function displayOrderSummaryHTML($summary)
{
	global $currency_h;
	?>
	<table>
	<tr>
		<th>Customer Details</th>
		<td><?php echo $summary->customername ?></td>
	</tr>
	<tr>
		<th>Date</th>
		<td><?php echo $summary->date ?></td>
	</tr>
	<tr>
		<th>Transaction ID</th>
		<td><?php echo $summary->orderid ?></td>
	</tr>
	<tr>
		<th>Transaction Ref</th>
		<td><?php echo $summary->ordertitle ?></td>
	</tr>
	<?php
	if(isset($summary->products) && count($summary->products) > 0){
		$ticketsCount = 0;
		foreach($summary->products as $product) {
			if(isset($product)){
				$ticketsCount += $product->quantity;
			}
		}
		if($ticketsCount > 0){
			?>
			<tr>
				<th valign="top">Tickets Purchased (<?php echo $ticketsCount?>)</th>
				<td>
					<table>
						<tr>
							<th>Event</th>
							<th>Qty</th>
							<th>Item</th>
							<?php if(DISPLAY_BARCODE) { ?><th>Barcode</th><?php } ?>
						</tr>
						<?php
						displayTickets($summary->products);
						?>
					</table>
				</td>
			</tr>
		<?php
		}
	}
	?>

	<?php
	if(isset($summary->schemes)){
		?>
		<tr>
			<th style="vertical-align: top">Schemes Purchased (<?php echo count($summary->schemes)?>)</th>
			<td>
				<table>
					<tr>
						<th>Scheme</th><th>Level</th><th>Price</th>
					</tr>
					<?php
					if(!is_array($summary->schemes)) {
						$schemes = array($summary->schemes);
					}
					else {
						$schemes = $summary->schemes;
					}
					foreach($schemes as $scheme){
						?>
						<tr>
							<td><?php echo $scheme->title ?> </td>
							<td><?php echo $scheme->tierTitle ?>
								<?php
								if(isset($scheme->concessions[0])) {
									print " - " . $scheme->concessions[0]->title;
								}
								?>
							</td>
							<td><?php echo $currency_h ?>&nbsp;<?php printf("%01.2f", $scheme->fee) ?></td>
						</tr>
					<?php
					}
					?>
				</table>
		</tr>
	<?php
	}
	?>
	<?php
	if(isset($summary->merchandise)){
		?>

		<tr>
			<th style="vertical-align: top">Merchandise Purchased (<?php echo count($summary->merchandise)?>)</th>
			<td>
				<table>
					<tr>
						<th>Merchandise</th><th>Quantity</th><th>Price</th>
					</tr>
					<?php
					if(!is_array($summary->merchandise)) {
						$merchandiseArr = array($summary->merchandise);
					}
					else {
						$merchandiseArr = $summary->merchandise;
					}
					foreach($merchandiseArr as $merchandise){
						$varTitle = $merchandise->variationTitle;
						if(!$merchandise->defaultVariation){
							$varTitle = $merchandise->merchandiseTitle . " - " . $varTitle;
						}
						?>
						<tr>
							<td><?php echo $varTitle ?> </td>
							<td><?php echo $merchandise->quantity ?> </td>
							<td><?php echo $currency_h ?>&nbsp;<?php printf("%01.2f", $merchandise->value) ?></td>
						</tr>
					<?php
					}
					?>
				</table>
		</tr>
	<?php
	}
	?>

	<?php
	if(isset($summary->vouchers)){
		?>

		<tr>
			<th style="vertical-align: top">Vouchers Purchased (<?php echo count($summary->vouchers)?>)</th>
			<td>
				<table>
					<tr>
						<th>Voucher</th><th>Price</th>
					</tr>
					<?php
					if(!is_array($summary->vouchers)) {
						$vouchers = array($summary->vouchers);
					}
					else {
						$vouchers = $summary->vouchers;
					}
					foreach($vouchers as $voucher){
						?>
						<tr>
							<td><?php echo $voucher->title ?> </td>
							<td><?php echo $currency_h ?>&nbsp;<?php printf("%01.2f", $voucher->credit) ?></td>
						</tr>
					<?php
					}
					?>
				</table>
		</tr>
	<?php
	}
	?>

	<?php
	if(isset($summary->donations)){ ?>
		<tr><th style="vertical-align: top">Donations:</th></tr>
		<?php foreach ($summary->donations as $i=>$donation) {
			$ga= "Non gift aid";
			if($donation->giftaid){
				$ga = "Gift Aid";
			}
			?>
			<tr>
				<td><?php echo $donation->title ?></td>
				<td><?php echo $currency_h?>&nbsp;<?php printf("%01.2f", $donation->amount); printf(" ".$ga)?></td>
			</tr>
		<?php
		}
	}
	?>

	<tr>
		<th>SubTotal</th>
		<td><?php echo $currency_h ?>&nbsp;<?php echo $summary->subtotal ?></td>
	</tr>
	<?php if($summary->orderFee > 0) { ?>
		<tr>
			<th>Handling Fee</th>
			<td><?php echo $currency_h ?>&nbsp;<?php echo $summary->orderFee ?></td>
		</tr>
	<?php } ?>
	<?php if($summary->postagefee > 0) { ?>
		<tr>
			<th>Postage Fee</th>
			<td><?php echo $currency_h ?>&nbsp;<?php echo $summary->postagefee ?></td>
		</tr>
	<?php } ?>
	<?php if($summary->discount < 0) { ?>
		<tr>
			<th>Discounts</th>
			<td><?php echo $currency_h ?>&nbsp;<?php echo $summary->discount ?></td>
		</tr>
	<?php } ?>
	<tr>
		<th>Total</th>
		<td><?php echo $currency_h ?>&nbsp;<?php echo $summary->total ?></td>
	</tr>
	</table>
	<?php if(DISPLAY_BARCODE) { ?>
	<h2>eTicket</h2>
	<img src="<?php echo $summary->barcodeURL ?>"/>
<?php } ?>
	<?php
	google_ecommerce($summary);

}
function displayReservationSummaryHTML($summary){
	?>
	<table>
		<tr>
			<th>Customer Details</th>
			<td><?php echo $summary->customername ?></td>
		</tr>
		<tr>
			<th>Date</th>
			<td><?php echo $summary->date ?></td>
		</tr>
		<tr>
			<th>Transaction ID</th>
			<td><?php echo $summary->orderid ?></td>
		</tr>
		<tr>
			<th>Transaction Ref</th>
			<td><?php echo $summary->ordertitle ?></td>
		</tr>
		<?php
		if(isset($summary->products) && count($summary->products) > 0){
			$ticketsCount = 0;
			foreach($summary->products as $product) {
				if(isset($product)){
					$ticketsCount += $product->quantity;
				}
			}
			if($ticketsCount > 0){
				?>
				<tr>
					<th>Tickets Reserved (<?php echo $ticketsCount?>)</th>
					<td>
						<table>
							<tr>
								<th>Event</th>
								<th>Qty</th>
								<th>Item</th>
							</tr>
							<?php
							displayTickets($summary->products);
							?>
						</table>
					</td>
				</tr>
			<?php
			}
		}
		?>
	</table>
<?php
}

function displayTickets($products){
	if(!is_array($products)) {
		$products = array($products);
	}
	foreach($products as $product) { ?>
		<tr valign="top">
			<td valign="top"><?php echo $product->event ?> @ <?php echo $product->venue ?> in <?php echo $product->subvenue ?> @ <?php echo apply30HourRule($product->date) ?></td>
			<td valign="top"><?php echo $product->quantity ?></td>
			<td valign="top"><?php echo $product->pricebandconcession ?><?php if($product->performanceconcession) print " - " . $product->performanceconcession; ?><?php if($product->reserved) print " <br>[".$product->area." ".$product->block." ".$product->row.$product->seat."]"; ?></td>
			<?php if(DISPLAY_BARCODE) { ?>
				<td valign="top"><?php
					foreach($product->barcodes as $barcode) {
						print "<img src=\"barcode.php?code=$barcode\" /><br/>";
					}
					?>
				</td>
			<?php } ?>
		</tr>
	<?php }
}


function getEmailSummary($summary)
{
	// arrg, bloody soap
	if(isset($summary->products)){
		if(!is_array($summary->products)) {
			$products = array($summary->products);
		}
		else {
			$products = $summary->products;
		}
	}else{
		$products = array();
	}
	if(isset($summary->schemes)){
		if(!is_array($summary->schemes)) {
			$schemes = array($summary->schemes);
		}else{
			$schemes = $summary->schemes;
		}
	}else{
		$schemes = array();
	}
	$string = "";
	$string .= "Customer Details: $summary->customername\n";
	$string .= "Date: $summary->date\n";
	$string .= "Transaction ID: $summary->orderid\n";
	$string .= "Transaction Ref: $summary->ordertitle\n";
	if(count($products) > 0){
		$ticketsCount = 0;
		foreach($products as $product) {
			$ticketsCount += $product->quantity;
		}
		$string .= "Tickets Purchased: ($ticketsCount)\n";

		if($summary->post == 0) {
			$string .="\n\nPresent your Transaction ID at the Box Office to collect your tickets\n\n";
		} else {
			$string .= "\n\nYour tickets will be posted out to the address you supplied\n\n";
		}
		foreach($products as $product) {
			$string .= "\t$product->event @ $product->venue in $product->subvenue @ " . apply30HourRule($product->date) . " ";
			$string .= "$product->quantity x ";
			$ticketsAmount = $product->quantity * $product->price;
			if($product->priceband != "Price band 1") $string .= $product->priceband . " - ";
			$string .= "$product->pricebandconcession";
			if($product->performanceconcession) {
				$string .= " - $product->performanceconcession";
			}
			$string .= " $currency_p$product->price = $currency_p$ticketsAmount";
			if($product->reserved) $string .= " [".$product->block." ".$product->row.$product->seat."]";
			$string .= " $product->boughtUnderScheme";
			$string .= "\n";

		}
		$string .= "\n";
	}

	if(count($schemes > 0)){
		$string .= "Subscriptions Purchased: (". count($schemes).")\n";
		foreach($schemes as $scheme){
			$string .= "\t".$scheme->title." $currency_p".$scheme->fee . "\n";
		}
	}
	$string .="\nSubTotal: $currency_p $summary->subtotal\n";
	$string .= "Fees: $currency_p $summary->feeTotal\n";
	$string .= "Total: $currency_p $summary->total\n";

	return($string);
}

/**
 * Applies the Fringe "30 hour rule" to a date. This produces a string
 * that is suitable for display both in the GUI and on tickets.
 * <p>
 * The 30 hour rule stipulates that if a show starts between 00:00 and
 * 06:00 on a day <code>n</code>, then its date should be treated as
 * <code>n-1</code>. Thus a show at Sun 10 Aug 2008 01:00 should
 * use a date of "Sat 09 Aug 2008" 01:00. Note that quotes should
 * be included to emphasise that this is not the true date.
 *
 * @param mixed date the date to apply the rule to, either as a String or as a
 *        UNIX timestamp
 * @return string a string representation of <code>date</code> formattted
 *         according to the 30 hour rule.
 */
function apply30HourRule($date) {
	if (!is_numeric($date)) {
		$date = str_replace("24:","00:",$date);
		$unixtime = strtotime($date);
	} else {
		$unixtime = $date;
	}
#		if(!$unixtime) print "we are epoch [$date]";
	if (date('G', $unixtime) < 6) {
		// Apply rule
		$retDate = '"' . date('D d M Y', $unixtime - (24 * 60 * 60)) . '"';
	} else {
		// Don't apply
		$retDate = date('D d M Y', $unixtime);
	}
	return $retDate . ' ' . date('H:i', $unixtime);
}

function createQRUrl($id,$ref) {
	return("http://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "/qr_img.php?id=" . urlencode($id) . "&ref=" . urlencode($ref));
}

function scheme_benefits_explaination($st)
{
	$msg = "You may purchase discounted tickets for ";
	if($st->performanceEventLimit) {
		$msg .= $st->performanceEventLimit;
	}
	else {
		$msg .= "an unlimited";
	}
	$msg .= " number of " . $st->maxCountContext . "s";
	if($st->maxPerPerformanceEvent) {
		$msg .= ", with a maximum of " . $st->maxPerPerformanceEvent . " tickets in any given performance";
	}
	return($msg);
}

function google_ecommerce($summary) {
	if(!defined('GOOGLE_UA')) return;
	?>
	<script type="text/javascript">

		var _gaq = _gaq || [];
		_gaq.push(['_setAccount', '<?php echo GOOGLE_UA ?>']);
		_gaq.push(['_trackPageview']);
		_gaq.push(['_addTrans',
			'<?php echo $summary->orderid ?>',
			'<?php echo $_SERVER['HTTP_HOST'] ?>',
			'<?php echo $summary->total ?>',
			'0', // tax
			'<?php echo $summary->postagefee ?>',
			'City',
			'State',
			'Country'
		]);

		// add item might be called for every item in the shopping cart
		// where your ecommerce engine loops through each item in the cart and
		// prints out _addItem for each
		<?php foreach($summary->products as $product) { ?>
		_gaq.push(['_addItem',
			'<?php echo $summary->orderid ?>',
			'E:<?php echo $product->eventId ?>',
			'<?php echo $product->event ?>',
			'<?php echo $product->priceband ?> - <?php echo $product->pricebandconcession ?><?php if($product->performanceconcession) print " - " . $product->performanceconcession; ?>',
			'<?php echo $product->price ?>',
			'<?php echo $product->quantity ?>'
		]);
		<?php } ?>
		_gaq.push(['_trackTrans']); //submits transaction to the Analytics servers

		(function() {
			var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
			ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
			var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
		})();

	</script>
<?php
}

function create3DSecurePOST($redirect) {

	$redirect = trim($redirect);
	$urlArray = parse_url($redirect);
	$pathAndQuery = $urlArray['path'];
	$post = array();
	$get = array(); // should never be query string in POST, but some ACSs are broken
	foreach(explode("&",$urlArray['query']) as $part) {
		if(preg_match("/([^=]+)=(.+)/",$part,$matches)) {
			$key = $matches[1];
			if(in_array($key, array('MD','PaReq'))) {
				$post[$key] = urldecode($matches[2]);
			}
			else {
				$get[$key] = $part;
			}
		}
	}
	if(count($get)) {
		$pathAndQuery .= "?" . implode("&", $get);
	}
	?>
	<html>
	<body onLoad="redirect();" >
	Redirecting to your banks website, please wait ...
	<?php
	print "<form name=\"downloadForm\" action=\"".$urlArray['scheme']."://".$urlArray['host'].$pathAndQuery."\" method=\"POST\">";

	foreach($post as $key=>$value) {
		print "<input type=\"hidden\" name=\"$key\" value=\"$value\"/>\n";
	}
	print "<input type=\"hidden\" name=\"TermUrl\" value=\"http://".$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']."\">";
	?>
	<input type="submit" value=">>"/>
	</form>
	<script language="Javascript" >
		<!--
		function redirect(){
			document.downloadForm.submit();
		}
		//-->
	</script>
	</body>
	</html>
<?php
}
