<?php
/**
 * Defines the ViaApiVoucherTypeBasketItem data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * 
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiVoucherTypeBasketItem.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiVoucherTypeBasketItem.
 */
abstract class ViaApiVoucherTypeBasketItem {

  /**
   * The reference of this voucher type of the form "serverId:voucherTypeId".
   *
   * @var string
   */
  protected $typeRef;

  /**
   * The title of this voucher type.
   *
   * @var string
   */
  protected $title;

  /**
   * The value (and therefore cost) of this voucher type.
   *
   * @var double
   */
  protected $value;

  /**
   * The number of days this voucher will expire in once bought.
   *
   * @var int
   */
  protected $expireIn;

  /**
   * The quantity of this type. When part of a {@link ViaApiBasket} object this is the number of items in the basket.
   * Otherwise it can be ignored.
   *
   * @var int
   */
  protected $quantity;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'typeRef':
        return $this->getTypeRef();
      case 'title':
        return $this->getTitle();
      case 'value':
        return $this->getValue();
      case 'expireIn':
        return $this->getExpireIn();
      case 'quantity':
        return $this->getQuantity();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * The reference of this voucher type of the form "serverId:voucherTypeId".
   *
   * @return string
   */
  public function getTypeRef()
  {
    return $this->typeRef;
  }


  /**
   * The title of this voucher type.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The value (and therefore cost) of this voucher type.
   *
   * @return double
   */
  public function getValue()
  {
    return $this->value;
  }


  /**
   * The number of days this voucher will expire in once bought.
   *
   * @return int
   */
  public function getExpireIn()
  {
    return $this->expireIn;
  }


  /**
   * The quantity of this type. When part of a {@link ViaApiBasket} object this is the number of items in the basket.
   * Otherwise it can be ignored.
   *
   * @return int
   */
  public function getQuantity()
  {
    return $this->quantity;
  }


}
