<?php
/**
 * Defines the ViaApiVoucherDetails data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Contains the details of a customers voucher.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiVoucherDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiVoucherDetails.
 */
abstract class ViaApiVoucherDetails {

  /**
   * The reference of this voucher of the form "serverId:voucherId"
   *
   * @var string
   */
  protected $voucherRef;

  /**
   * The title of this vouchers voucher type.
   *
   * @var string
   */
  protected $title;

  /**
   * The remaining credit on this voucher.
   *
   * @var double
   */
  protected $credit;

  /**
   * A string representation of the date this voucher will expire in the form "yyyy-MM-dd HH:mm:ss"
   * See the {@link java.text.SimpleDateFormat} documentation for information on this format.
   *
   * @var string
   */
  protected $expiry;

  /**
   * The item id of this voucher in this transaction
   *
   * @var int
   */
  protected $itemId;

  /**
   * whether this voucher has been refunded
   *
   * @var bool
   */
  protected $refunded;

  /**
   * The forename of the customer that has claimed / been gifted this voucher using a token
   *
   * @var string
   */
  protected $customerForename;

  /**
   * The surname of the customer that has claimed / been gifted this voucher using a token
   *
   * @var string
   */
  protected $customerSurname;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'voucherRef':
        return $this->getVoucherRef();
      case 'title':
        return $this->getTitle();
      case 'credit':
        return $this->getCredit();
      case 'expiry':
        return $this->getExpiry();
      case 'itemId':
        return $this->getItemId();
      case 'refunded':
        return $this->getRefunded();
      case 'customerForename':
        return $this->getCustomerForename();
      case 'customerSurname':
        return $this->getCustomerSurname();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * The reference of this voucher of the form "serverId:voucherId"
   *
   * @return string
   */
  public function getVoucherRef()
  {
    return $this->voucherRef;
  }


  /**
   * The title of this vouchers voucher type.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The remaining credit on this voucher.
   *
   * @return double
   */
  public function getCredit()
  {
    return $this->credit;
  }


  /**
   * A string representation of the date this voucher will expire in the form "yyyy-MM-dd HH:mm:ss"
   * See the {@link java.text.SimpleDateFormat} documentation for information on this format.
   *
   * @return string
   */
  public function getExpiry()
  {
    return $this->expiry;
  }


  /**
   * The item id of this voucher in this transaction
   *
   * @return int
   */
  public function getItemId()
  {
    return $this->itemId;
  }


  /**
   * whether this voucher has been refunded
   *
   * @return bool
   */
  public function getRefunded()
  {
    return $this->refunded;
  }


  /**
   * The forename of the customer that has claimed / been gifted this voucher using a token
   *
   * @return string
   */
  public function getCustomerForename()
  {
    return $this->customerForename;
  }


  /**
   * The surname of the customer that has claimed / been gifted this voucher using a token
   *
   * @return string
   */
  public function getCustomerSurname()
  {
    return $this->customerSurname;
  }


}
