<?php
/**
 * Defines the ViaApiTicketRequest data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Represents a request for tickets. Used by {@link ViaApiService#apiAddTicketsToBasket(java.lang.String,
 * java.util.List, int, java.lang.String, java.lang.String)}
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiTicketRequest.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiTicketRequest.
 */
abstract class ViaApiTicketRequest {

  /**
   * The id of the price band of the requested tickets.
   *
   * @var int
   */
  protected $priceBandId;

  /**
   * The id of the concession to be applied to the selected tickets.
   *
   * @var int
   */
  protected $concessionId;

  /**
   * The promo code of the selected concession if any.
   *
   * @var string
   */
  protected $promoCode;

  /**
   * The number of seats requested.
   *
   * @var int
   */
  protected $quantity;

  /**
   * An array containing the ids of any preferred seats or null.
   *
   * @var int[]
   */
  protected $perferredSeats;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'priceBandId':
        return $this->getPriceBandId();
      case 'concessionId':
        return $this->getConcessionId();
      case 'promoCode':
        return $this->getPromoCode();
      case 'quantity':
        return $this->getQuantity();
      case 'perferredSeats':
        return $this->getPerferredSeats();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * The id of the price band of the requested tickets.
   *
   * @return int
   */
  public function getPriceBandId()
  {
    return $this->priceBandId;
  }


  /**
   * The id of the concession to be applied to the selected tickets.
   *
   * @return int
   */
  public function getConcessionId()
  {
    return $this->concessionId;
  }


  /**
   * The promo code of the selected concession if any.
   *
   * @return string
   */
  public function getPromoCode()
  {
    return $this->promoCode;
  }


  /**
   * The number of seats requested.
   *
   * @return int
   */
  public function getQuantity()
  {
    return $this->quantity;
  }


  /**
   * An array containing the ids of any preferred seats or null.
   *
   * @return int[]
   */
  public function getPerferredSeats()
  {
	return $this->perferredSeats ? : array();
  }


}
