<?php
/**
 * Defines the ViaApiSubscriptionBasketItem data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * 
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiSubscriptionBasketItem.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiSubscriptionBasketItem.
 */
abstract class ViaApiSubscriptionBasketItem {

  /**
   * The reference of the scheme this tier is a member of in the form "serverId:schemeId"
   *
   * @var string
   */
  protected $schemeRef;

  /**
   * The title of the scheme this tier is a member of.
   *
   * @var string
   */
  protected $title;

  /**
   * The code of the scheme this tier is a member of.
   *
   * @var string
   */
  protected $code;

  /**
   * The cost for this scheme tier.
   *
   * @var double
   */
  protected $fee;

  /**
   * The reference for the actual tier in the form "serverId:schemeId:tierId".
   *
   * @var string
   */
  protected $tierId;

  /**
   * The title of this scheme tier.
   *
   * @var string
   */
  protected $tierTitle;

  /**
   * Whether or not this scheme tier is gift aidable.
   *
   * @var bool
   */
  protected $isGiftAidable;

  /**
   * The gift aidable value of this scheme tier.
   *
   * @var double
   */
  protected $donationValue;

  /**
   * The concession title
   *
   * @var string
   */
  protected $concessionTitle;

  /**
   * The concession id in the form of serverId:concessionId
   *
   * @var string
   */
  protected $concessionId;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'schemeRef':
        return $this->getSchemeRef();
      case 'title':
        return $this->getTitle();
      case 'code':
        return $this->getCode();
      case 'fee':
        return $this->getFee();
      case 'tierId':
        return $this->getTierId();
      case 'tierTitle':
        return $this->getTierTitle();
      case 'isGiftAidable':
        return $this->getIsGiftAidable();
      case 'donationValue':
        return $this->getDonationValue();
      case 'concessionTitle':
        return $this->getConcessionTitle();
      case 'concessionId':
        return $this->getConcessionId();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * The reference of the scheme this tier is a member of in the form "serverId:schemeId"
   *
   * @return string
   */
  public function getSchemeRef()
  {
    return $this->schemeRef;
  }


  /**
   * The title of the scheme this tier is a member of.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The code of the scheme this tier is a member of.
   *
   * @return string
   */
  public function getCode()
  {
    return $this->code;
  }


  /**
   * The cost for this scheme tier.
   *
   * @return double
   */
  public function getFee()
  {
    return $this->fee;
  }


  /**
   * The reference for the actual tier in the form "serverId:schemeId:tierId".
   *
   * @return string
   */
  public function getTierId()
  {
    return $this->tierId;
  }


  /**
   * The title of this scheme tier.
   *
   * @return string
   */
  public function getTierTitle()
  {
    return $this->tierTitle;
  }


  /**
   * Whether or not this scheme tier is gift aidable.
   *
   * @return bool
   */
  public function getIsGiftAidable()
  {
    return $this->isGiftAidable;
  }


  /**
   * The gift aidable value of this scheme tier.
   *
   * @return double
   */
  public function getDonationValue()
  {
    return $this->donationValue;
  }


  /**
   * The concession title
   *
   * @return string
   */
  public function getConcessionTitle()
  {
    return $this->concessionTitle;
  }


  /**
   * The concession id in the form of serverId:concessionId
   *
   * @return string
   */
  public function getConcessionId()
  {
    return $this->concessionId;
  }


}
