<?php
/**
 * Defines the ViaApiSeasonDetails data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores information about a particular Season.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiSeasonDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiSeasonDetails.
 */
abstract class ViaApiSeasonDetails {

  /**
   * Id of this Season.
   *
   * @var int
   */
  protected $seasonId;

  /**
   * The Title given to this Season.
   *
   * @var string
   */
  protected $title;

  /**
   * Whether or not this season is currently
   * active.
   *
   * @var bool
   */
  protected $active;

  /**
   * The code for this Season.
   *
   * @var string
   */
  protected $code;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'seasonId':
        return $this->getSeasonId();
      case 'title':
        return $this->getTitle();
      case 'active':
        return $this->getActive();
      case 'code':
        return $this->getCode();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Id of this Season.
   *
   * @return int
   */
  public function getSeasonId()
  {
    return $this->seasonId;
  }


  /**
   * The Title given to this Season.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * Whether or not this season is currently
   * active.
   *
   * @return bool
   */
  public function getActive()
  {
    return $this->active;
  }


  /**
   * The code for this Season.
   *
   * @return string
   */
  public function getCode()
  {
    return $this->code;
  }


}
