<?php
/**
 * Defines the ViaApiPriceConcession data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores information on a Price Concession
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiPriceConcession.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiPriceConcession.
 */
abstract class ViaApiPriceConcession {

  /**
   * The code of this price concession.
   *
   * @var string
   */
  protected $code;

  /**
   * The concession title.
   *
   * @var string
   */
  protected $title;

  /**
   * The value of this concession.
   *
   * @var string
   */
  protected $concPrice;

  /**
   * The id of this price concession.
   *
   * @var int
   */
  protected $concessionid;

  /**
   * Return the concession required quantity. This is the amount of tickets that must
   * have the concession before a discount is applied. I.e. for a required quantity of 3 the concession
   * can only be applied to groups of three tickets or more.
   *
   * @var int
   */
  protected $concessionRequiredQty;

  /**
   * The price concession description.
   *
   * @var string
   */
  protected $description;

  /**
   * Whether this is a limited concession.
   *
   * @var bool
   */
  protected $limited;

  /**
   * Whether or not this concession requires the use of a promocode.
   *
   * @var bool
   */
  protected $promoCodeRequired;

  /**
   * Whether or not this concession is gift aidable.
   *
   * @var bool
   */
  protected $isGiftAidable;

  /**
   * The gift aidable value of this concession.
   *
   * @var double
   */
  protected $donationValue;

  /**
   * The value that this concession is limited to
   * if this concession is limited to a certain amount.
   *
   * @var int
   */
  protected $limitValue;

  /**
   * An estimate of the remaining number of
   * applications this concession can have.
   *
   * @var int
   */
  protected $remainingLimitValue;

  /**
   * The Key of the ticket offer relating to this concession in the form serverId:PB:priceBandConcessionId.
   *
   * @var string
   */
  protected $ticketOfferKey;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'code':
        return $this->getCode();
      case 'title':
        return $this->getTitle();
      case 'concPrice':
        return $this->getConcPrice();
      case 'concessionid':
        return $this->getConcessionid();
      case 'concessionRequiredQty':
        return $this->getConcessionRequiredQty();
      case 'description':
        return $this->getDescription();
      case 'limited':
        return $this->getLimited();
      case 'promoCodeRequired':
        return $this->getPromoCodeRequired();
      case 'isGiftAidable':
        return $this->getIsGiftAidable();
      case 'donationValue':
        return $this->getDonationValue();
      case 'limitValue':
        return $this->getLimitValue();
      case 'remainingLimitValue':
        return $this->getRemainingLimitValue();
      case 'ticketOfferKey':
        return $this->getTicketOfferKey();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * The code of this price concession.
   *
   * @return string
   */
  public function getCode()
  {
    return $this->code;
  }


  /**
   * The concession title.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The value of this concession.
   *
   * @return string
   */
  public function getConcPrice()
  {
    return $this->concPrice;
  }


  /**
   * The id of this price concession.
   *
   * @return int
   */
  public function getConcessionid()
  {
    return $this->concessionid;
  }


  /**
   * Return the concession required quantity. This is the amount of tickets that must
   * have the concession before a discount is applied. I.e. for a required quantity of 3 the concession
   * can only be applied to groups of three tickets or more.
   *
   * @return int
   */
  public function getConcessionRequiredQty()
  {
    return $this->concessionRequiredQty;
  }


  /**
   * The price concession description.
   *
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }


  /**
   * Whether this is a limited concession.
   *
   * @return bool
   */
  public function getLimited()
  {
    return $this->limited;
  }


  /**
   * Whether or not this concession requires the use of a promocode.
   *
   * @return bool
   */
  public function getPromoCodeRequired()
  {
    return $this->promoCodeRequired;
  }


  /**
   * Whether or not this concession is gift aidable.
   *
   * @return bool
   */
  public function getIsGiftAidable()
  {
    return $this->isGiftAidable;
  }


  /**
   * The gift aidable value of this concession.
   *
   * @return double
   */
  public function getDonationValue()
  {
    return $this->donationValue;
  }


  /**
   * The value that this concession is limited to
   * if this concession is limited to a certain amount.
   *
   * @return int
   */
  public function getLimitValue()
  {
    return $this->limitValue;
  }


  /**
   * An estimate of the remaining number of
   * applications this concession can have.
   *
   * @return int
   */
  public function getRemainingLimitValue()
  {
    return $this->remainingLimitValue;
  }


  /**
   * The Key of the ticket offer relating to this concession in the form serverId:PB:priceBandConcessionId.
   *
   * @return string
   */
  public function getTicketOfferKey()
  {
    return $this->ticketOfferKey;
  }


}
