<?php
/**
 * Defines the ViaApiPerformancePrice data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores the details of a price band of a performance.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiPerformancePrice.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiPerformancePrice.
 */
abstract class ViaApiPerformancePrice {

  /**
   * The id of this price band.
   *
   * @var int
   */
  protected $pricebandid;

  /**
   * The full price of this price band.
   *
   * @var string
   */
  protected $price;

  /**
   * The title of this price band.
   *
   * @var string
   */
  protected $pricetype;

  /**
   * Description of this price band
   *
   * @var string
   */
  protected $description;

  /**
   * The level of reservation for seats in this price band. Values are NONE (unreserved), AREA, BLOCK, ROW, SEAT.
   *
   * @var string
   */
  protected $priceBandReservationLevel;

  /**
   * Boolean indicating whether there are still seats available.
   *
   * @var bool
   */
  protected $seats;

  /**
   * An array of price concessions available for this price band.
   *
   * @var \Red61\Via\DataObject\ViaApiPriceConcession[]
   */
  protected $concessions;

  /**
   * If true then only concession purchase are permitted. Purchasing a full price ticket is not possible.
   *
   * @var bool
   */
  protected $hideFullPrice;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'pricebandid':
        return $this->getPricebandid();
      case 'price':
        return $this->getPrice();
      case 'pricetype':
        return $this->getPricetype();
      case 'description':
        return $this->getDescription();
      case 'priceBandReservationLevel':
        return $this->getPriceBandReservationLevel();
      case 'seats':
        return $this->getSeats();
      case 'concessions':
        return $this->getConcessions();
      case 'hideFullPrice':
        return $this->getHideFullPrice();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * The id of this price band.
   *
   * @return int
   */
  public function getPricebandid()
  {
    return $this->pricebandid;
  }


  /**
   * The full price of this price band.
   *
   * @return string
   */
  public function getPrice()
  {
    return $this->price;
  }


  /**
   * The title of this price band.
   *
   * @return string
   */
  public function getPricetype()
  {
    return $this->pricetype;
  }


  /**
   * Description of this price band
   *
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }


  /**
   * The level of reservation for seats in this price band. Values are NONE (unreserved), AREA, BLOCK, ROW, SEAT.
   *
   * @return string
   */
  public function getPriceBandReservationLevel()
  {
    return $this->priceBandReservationLevel;
  }


  /**
   * Boolean indicating whether there are still seats available.
   *
   * @return bool
   */
  public function getSeats()
  {
    return $this->seats;
  }


  /**
   * An array of price concessions available for this price band.
   *
   * @return \Red61\Via\DataObject\ViaApiPriceConcession[]
   */
  public function getConcessions()
  {
	return $this->concessions ? : array();
  }


  /**
   * If true then only concession purchase are permitted. Purchasing a full price ticket is not possible.
   *
   * @return bool
   */
  public function getHideFullPrice()
  {
    return $this->hideFullPrice;
  }


}
