<?php
/**
 * Defines the ViaApiMerchandiseBasketItem data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Represents the amount of a merchandise variation in the basket.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiMerchandiseBasketItem.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiMerchandiseBasketItem.
 */
abstract class ViaApiMerchandiseBasketItem {

  /**
   * The code of the merchandise.
   *
   * @var string
   */
  protected $merchandiseCode;

  /**
   * The title of the merchandise.
   *
   * @var string
   */
  protected $merchandiseTitle;

  /**
   * The reference of the variation this basket item represents in the form "serverId:variationId"
   *
   * @var string
   */
  protected $variationRef;

  /**
   * The code of this variation.
   *
   * @var string
   */
  protected $variationCode;

  /**
   * The title of this variation.
   *
   * @var string
   */
  protected $variationTitle;

  /**
   * The cost of a single variation.
   *
   * @var double
   */
  protected $value;

  /**
   * The number of this variation in the basket.
   *
   * @var int
   */
  protected $quantity;

  /**
   * See {@link ViaApiMerchandiseVariation#defaultVariation}
   *
   * @var bool
   */
  protected $defaultVariation;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'merchandiseCode':
        return $this->getMerchandiseCode();
      case 'merchandiseTitle':
        return $this->getMerchandiseTitle();
      case 'variationRef':
        return $this->getVariationRef();
      case 'variationCode':
        return $this->getVariationCode();
      case 'variationTitle':
        return $this->getVariationTitle();
      case 'value':
        return $this->getValue();
      case 'quantity':
        return $this->getQuantity();
      case 'defaultVariation':
        return $this->getDefaultVariation();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * The code of the merchandise.
   *
   * @return string
   */
  public function getMerchandiseCode()
  {
    return $this->merchandiseCode;
  }


  /**
   * The title of the merchandise.
   *
   * @return string
   */
  public function getMerchandiseTitle()
  {
    return $this->merchandiseTitle;
  }


  /**
   * The reference of the variation this basket item represents in the form "serverId:variationId"
   *
   * @return string
   */
  public function getVariationRef()
  {
    return $this->variationRef;
  }


  /**
   * The code of this variation.
   *
   * @return string
   */
  public function getVariationCode()
  {
    return $this->variationCode;
  }


  /**
   * The title of this variation.
   *
   * @return string
   */
  public function getVariationTitle()
  {
    return $this->variationTitle;
  }


  /**
   * The cost of a single variation.
   *
   * @return double
   */
  public function getValue()
  {
    return $this->value;
  }


  /**
   * The number of this variation in the basket.
   *
   * @return int
   */
  public function getQuantity()
  {
    return $this->quantity;
  }


  /**
   * See {@link ViaApiMerchandiseVariation#defaultVariation}
   *
   * @return bool
   */
  public function getDefaultVariation()
  {
    return $this->defaultVariation;
  }


}
