<?php
/**
 * Defines the ViaApiCustomerOtherDetails data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores extra details of a customer.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiCustomerOtherDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiCustomerOtherDetails.
 */
abstract class ViaApiCustomerOtherDetails {

  /**
   * The id of this record.
   *
   * @var int
   */
  protected $id;

  /**
   * The id of the customer these details are for.
   *
   * @var int
   */
  protected $customerid;

  /**
   * The daytime phone number of the customer.
   *
   * @var string
   */
  protected $dayphone;

  /**
   * The evening phone number of the customer.
   *
   * @var string
   */
  protected $evephone;

  /**
   * The fax number of the customer.
   *
   * @var string
   */
  protected $fax;

  /**
   * The mobile phone number of the customer.
   *
   * @var string
   */
  protected $mobile;

  /**
   * The email of the customer.
   *
   * @var string
   */
  protected $email;

  /**
   * The preferred contact method of the customer. One of "Any", "Email" or "Post".
   * May also be empty if no data is stored.
   *
   * @var string
   */
  protected $prefcontact;

  /**
   * The first line of the alternative address if one exists.
   *
   * @var string
   */
  protected $altstreet1;

  /**
   * The second line of the alternative address if one exists.
   *
   * @var string
   */
  protected $altstreet2;

  /**
   * The third line of the alternative address if one exists.
   *
   * @var string
   */
  protected $altstreet3;

  /**
   * The city of the alternative address if one exists.
   *
   * @var string
   */
  protected $altcity;

  /**
   * The county of the alternative address if one exists.
   *
   * @var string
   */
  protected $altcounty;

  /**
   * The country of the alternative address if one exists.
   *
   * @var string
   */
  protected $altcountry;

  /**
   * The po box of the alternative address if one exists.
   *
   * @var string
   */
  protected $altpobox;

  /**
   * The state of the alternative address if one exists.
   *
   * @var string
   */
  protected $altstate;

  /**
   * The post code of the alternative address if one exists.
   *
   * @var string
   */
  protected $altpostcode;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'id':
        return $this->getId();
      case 'customerid':
        return $this->getCustomerid();
      case 'dayphone':
        return $this->getDayphone();
      case 'evephone':
        return $this->getEvephone();
      case 'fax':
        return $this->getFax();
      case 'mobile':
        return $this->getMobile();
      case 'email':
        return $this->getEmail();
      case 'prefcontact':
        return $this->getPrefcontact();
      case 'altstreet1':
        return $this->getAltstreet1();
      case 'altstreet2':
        return $this->getAltstreet2();
      case 'altstreet3':
        return $this->getAltstreet3();
      case 'altcity':
        return $this->getAltcity();
      case 'altcounty':
        return $this->getAltcounty();
      case 'altcountry':
        return $this->getAltcountry();
      case 'altpobox':
        return $this->getAltpobox();
      case 'altstate':
        return $this->getAltstate();
      case 'altpostcode':
        return $this->getAltpostcode();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * The id of this record.
   *
   * @return int
   */
  public function getId()
  {
    return $this->id;
  }


  /**
   * The id of the customer these details are for.
   *
   * @return int
   */
  public function getCustomerid()
  {
    return $this->customerid;
  }


  /**
   * The daytime phone number of the customer.
   *
   * @return string
   */
  public function getDayphone()
  {
    return $this->dayphone;
  }


  /**
   * The evening phone number of the customer.
   *
   * @return string
   */
  public function getEvephone()
  {
    return $this->evephone;
  }


  /**
   * The fax number of the customer.
   *
   * @return string
   */
  public function getFax()
  {
    return $this->fax;
  }


  /**
   * The mobile phone number of the customer.
   *
   * @return string
   */
  public function getMobile()
  {
    return $this->mobile;
  }


  /**
   * The email of the customer.
   *
   * @return string
   */
  public function getEmail()
  {
    return $this->email;
  }


  /**
   * The preferred contact method of the customer. One of "Any", "Email" or "Post".
   * May also be empty if no data is stored.
   *
   * @return string
   */
  public function getPrefcontact()
  {
    return $this->prefcontact;
  }


  /**
   * The first line of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltstreet1()
  {
    return $this->altstreet1;
  }


  /**
   * The second line of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltstreet2()
  {
    return $this->altstreet2;
  }


  /**
   * The third line of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltstreet3()
  {
    return $this->altstreet3;
  }


  /**
   * The city of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltcity()
  {
    return $this->altcity;
  }


  /**
   * The county of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltcounty()
  {
    return $this->altcounty;
  }


  /**
   * The country of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltcountry()
  {
    return $this->altcountry;
  }


  /**
   * The po box of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltpobox()
  {
    return $this->altpobox;
  }


  /**
   * The state of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltstate()
  {
    return $this->altstate;
  }


  /**
   * The post code of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltpostcode()
  {
    return $this->altpostcode;
  }


}
