<?php
/**
 * Defines the ViaApiCustomCustomerFieldDetails data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores the details of a custom customer field.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiCustomCustomerFieldDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiCustomCustomerFieldDetails.
 */
abstract class ViaApiCustomCustomerFieldDetails {

  /**
   * The id of this custom field.
   *
   * @var int
   */
  protected $fieldId;

  /**
   * The title of this custom field.
   *
   * @var string
   */
  protected $title;

  /**
   * The description of this custom field.
   *
   * @var string
   */
  protected $description;

  /**
   * The type of this field. One of:
   * <ul>
   * <li>TEXT		- This field is a single line text field.
   * <li>TEXTAREA	- This field is a multi line text field
   * <li>INTEGER		- This field is an integer.
   * <li>DOUBLE		- This field is a double.
   * <li>CHOICE		- This field is a multiple choice field.
   * <ul/>
   *
   * @var string
   */
  protected $type;

  /**
   * The choices of this field if its {@link #type} is CHOICE.
   *
   * @var \Red61\Via\DataObject\ViaApiCustomCustomerFieldChoiceDetails[]
   */
  protected $choices;

  /**
   * The value of this field if its {@link #type} is *not* CHOICE.
   *
   * @var string
   */
  protected $entry;

  /**
   * The id of the selected choice for this field if its {@link #type} is CHOICE.
   *
   * @var int
   */
  protected $selectedChoice;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'fieldId':
        return $this->getFieldId();
      case 'title':
        return $this->getTitle();
      case 'description':
        return $this->getDescription();
      case 'type':
        return $this->getType();
      case 'choices':
        return $this->getChoices();
      case 'entry':
        return $this->getEntry();
      case 'selectedChoice':
        return $this->getSelectedChoice();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * The id of this custom field.
   *
   * @return int
   */
  public function getFieldId()
  {
    return $this->fieldId;
  }


  /**
   * The title of this custom field.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The description of this custom field.
   *
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }


  /**
   * The type of this field. One of:
   * <ul>
   * <li>TEXT		- This field is a single line text field.
   * <li>TEXTAREA	- This field is a multi line text field
   * <li>INTEGER		- This field is an integer.
   * <li>DOUBLE		- This field is a double.
   * <li>CHOICE		- This field is a multiple choice field.
   * <ul/>
   *
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }


  /**
   * The choices of this field if its {@link #type} is CHOICE.
   *
   * @return \Red61\Via\DataObject\ViaApiCustomCustomerFieldChoiceDetails[]
   */
  public function getChoices()
  {
	return $this->choices ? : array();
  }


  /**
   * The value of this field if its {@link #type} is *not* CHOICE.
   *
   * @return string
   */
  public function getEntry()
  {
    return $this->entry;
  }


  /**
   * The id of the selected choice for this field if its {@link #type} is CHOICE.
   *
   * @return int
   */
  public function getSelectedChoice()
  {
    return $this->selectedChoice;
  }


}
