<?php
/**
 * Defines the ViaApiBasketSubVenueItem data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores the information on a subvenue for which there are tickets in the basket.
 * This class contains a list of {@link ViaApiBasketEventItem} for which there are tickets in the basket.
 * This hierarchy continues down to performances which contain the {@link ViaApiProductDetails} objects
 * which contain the information on actual tickets.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiBasketSubVenueItem.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiBasketSubVenueItem.
 */
abstract class ViaApiBasketSubVenueItem {

  /**
   * The reference for this subvenue of the form "serverId:subvenueId".
   *
   * @var string
   */
  protected $subvenueid;

  /**
   * The name of this subvenue.
   *
   * @var string
   */
  protected $name;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'subvenueid':
        return $this->getSubvenueid();
      case 'name':
        return $this->getName();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * The reference for this subvenue of the form "serverId:subvenueId".
   *
   * @return string
   */
  public function getSubvenueid()
  {
    return $this->subvenueid;
  }


  /**
   * The name of this subvenue.
   *
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }


}
