<?php
/**
 * Defines the ViaApiBasketPerformanceItem data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores the information on a performance for which there are tickets in the basket.
 * This class contains an array of {@link ViaApiProductDetails} which contain the details of the products in the basket
 * for this performance.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiBasketPerformanceItem.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiBasketPerformanceItem.
 */
abstract class ViaApiBasketPerformanceItem {

  /**
   * The reference for this performance of the form "performanceId:venueId".
   *
   * @var string
   */
  protected $performanceid;

  /**
   * A list of {@link ViaApiProductDetails}.
   *
   * @var \Red61\Via\DataObject\ViaApiProductDetails[]
   */
  protected $tickets;

  /**
   * String representation of the date of this performance in the form "yyyy-MM-dd HH:mm:ss".
   * See the {@link java.text.SimpleDateFormat} documentation for information on this format.
   *
   * @var string
   */
  protected $datetime;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'performanceid':
        return $this->getPerformanceid();
      case 'tickets':
        return $this->getTickets();
      case 'datetime':
        return $this->getDatetime();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * The reference for this performance of the form "performanceId:venueId".
   *
   * @return string
   */
  public function getPerformanceid()
  {
    return $this->performanceid;
  }


  /**
   * A list of {@link ViaApiProductDetails}.
   *
   * @return \Red61\Via\DataObject\ViaApiProductDetails[]
   */
  public function getTickets()
  {
	return $this->tickets ? : array();
  }


  /**
   * String representation of the date of this performance in the form "yyyy-MM-dd HH:mm:ss".
   * See the {@link java.text.SimpleDateFormat} documentation for information on this format.
   *
   * @return string
   */
  public function getDatetime()
  {
    return $this->datetime;
  }


}
