<?php
/**
 * Defines the ViaApiAddressResult data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Represents a possible result of an address lookup. The chosen result should then be passed to {@link
 * ViaApiService#apiGetAddress(java.lang.String, java.lang.String) }.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiAddressResult.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiAddressResult.
 */
abstract class ViaApiAddressResult {

  /**
   * The third party reference for this address.
   *
   * @var string
   */
  protected $reference;

  /**
   * A user friendly string summarising this address
   *
   * @var string
   */
  protected $summary;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'reference':
        return $this->getReference();
      case 'summary':
        return $this->getSummary();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * The third party reference for this address.
   *
   * @return string
   */
  public function getReference()
  {
    return $this->reference;
  }


  /**
   * A user friendly string summarising this address
   *
   * @return string
   */
  public function getSummary()
  {
    return $this->summary;
  }


}
