<?php
/**
 * Defines the ViaApiAddressDetails data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores the address details used when querying or retrieving addresses from third party address providers.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiAddressDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiAddressDetails.
 */
abstract class ViaApiAddressDetails {

  /**
   * 
   *
   * @var string
   */
  protected $name;

  /**
   * 
   *
   * @var string
   */
  protected $address1;

  /**
   * 
   *
   * @var string
   */
  protected $address2;

  /**
   * 
   *
   * @var string
   */
  protected $address3;

  /**
   * 
   *
   * @var string
   */
  protected $county;

  /**
   * 
   *
   * @var string
   */
  protected $country;

  /**
   * 
   *
   * @var string
   */
  protected $postcode;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'name':
        return $this->getName();
      case 'address1':
        return $this->getAddress1();
      case 'address2':
        return $this->getAddress2();
      case 'address3':
        return $this->getAddress3();
      case 'county':
        return $this->getCounty();
      case 'country':
        return $this->getCountry();
      case 'postcode':
        return $this->getPostcode();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * 
   *
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }


  /**
   * 
   *
   * @return string
   */
  public function getAddress1()
  {
    return $this->address1;
  }


  /**
   * 
   *
   * @return string
   */
  public function getAddress2()
  {
    return $this->address2;
  }


  /**
   * 
   *
   * @return string
   */
  public function getAddress3()
  {
    return $this->address3;
  }


  /**
   * 
   *
   * @return string
   */
  public function getCounty()
  {
    return $this->county;
  }


  /**
   * 
   *
   * @return string
   */
  public function getCountry()
  {
    return $this->country;
  }


  /**
   * 
   *
   * @return string
   */
  public function getPostcode()
  {
    return $this->postcode;
  }


}
