<?php
/**
 * Defines the apiUpdateTicketConcessionRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method may be used to change the priceband concession for items already in the basket.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiUpdateTicketConcessionRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiUpdateTicketConcessionRequest.
 */
abstract class apiUpdateTicketConcessionRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiUpdateTicketConcession';

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * An int array of the product ids to change the priceband concession for.
   *
   * @var int[]
   */
  protected $productIds;

  /**
   * The id of the performance these products are from, in the form 'serverId:performanceId'
   *
   * @var string
   */
  protected $performanceRef;

  /**
   * The id of the priceband these products are from.
   *
   * @var int
   */
  protected $priceBandId;

  /**
   * The id of the price band concession(if any) these products have applied to them
   *
   * @var int
   */
  protected $priceBandConcessionId;

  /**
   * The new id of the price band concession(if any) to add to these products.
   *
   * @var int
   */
  protected $newPriceBandConcessionId;

  /**
   * The authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * An int array of the product ids to change the priceband concession for.
   *
   * @return int[]
   */
  public function getProductIds()
  {
    return $this->productIds;
  }


  /**
   * An int array of the product ids to change the priceband concession for.
   *
   * @param int[] $productIds
   *
   * @return $this
   */
  public function setProductIds($productIds)
  {
    $this->productIds = $productIds;
    return $this;
  }

  /**
   * The id of the performance these products are from, in the form 'serverId:performanceId'
   *
   * @return string
   */
  public function getPerformanceRef()
  {
    return $this->performanceRef;
  }


  /**
   * The id of the performance these products are from, in the form 'serverId:performanceId'
   *
   * @param string $performanceRef
   *
   * @return $this
   */
  public function setPerformanceRef($performanceRef)
  {
    $this->performanceRef = $performanceRef;
    return $this;
  }

  /**
   * The id of the priceband these products are from.
   *
   * @return int
   */
  public function getPriceBandId()
  {
    return $this->priceBandId;
  }


  /**
   * The id of the priceband these products are from.
   *
   * @param int $priceBandId
   *
   * @return $this
   */
  public function setPriceBandId($priceBandId)
  {
    $this->priceBandId = $priceBandId;
    return $this;
  }

  /**
   * The id of the price band concession(if any) these products have applied to them
   *
   * @return int
   */
  public function getPriceBandConcessionId()
  {
    return $this->priceBandConcessionId;
  }


  /**
   * The id of the price band concession(if any) these products have applied to them
   *
   * @param int $priceBandConcessionId
   *
   * @return $this
   */
  public function setPriceBandConcessionId($priceBandConcessionId)
  {
    $this->priceBandConcessionId = $priceBandConcessionId;
    return $this;
  }

  /**
   * The new id of the price band concession(if any) to add to these products.
   *
   * @return int
   */
  public function getNewPriceBandConcessionId()
  {
    return $this->newPriceBandConcessionId;
  }


  /**
   * The new id of the price band concession(if any) to add to these products.
   *
   * @param int $newPriceBandConcessionId
   *
   * @return $this
   */
  public function setNewPriceBandConcessionId($newPriceBandConcessionId)
  {
    $this->newPriceBandConcessionId = $newPriceBandConcessionId;
    return $this;
  }

  /**
   * The authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
