<?php
/**
 * Defines the apiSetCampaignTrackingIdRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Sets an id which is used to track which campaign was used to initiate the current basket.   campaignTrackingFields is
 * optional and stores any extra information used for tracking.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiSetCampaignTrackingIdRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiSetCampaignTrackingIdRequest.
 */
abstract class apiSetCampaignTrackingIdRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiSetCampaignTrackingId';

  /**
   * 
   *
   * @var int
   */
  protected $campaignTrackingId;

  /**
   * 
   *
   * @var string
   */
  protected $campaignTrackingFields;

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * 
   *
   * @return int
   */
  public function getCampaignTrackingId()
  {
    return $this->campaignTrackingId;
  }


  /**
   * 
   *
   * @param int $campaignTrackingId
   *
   * @return $this
   */
  public function setCampaignTrackingId($campaignTrackingId)
  {
    $this->campaignTrackingId = $campaignTrackingId;
    return $this;
  }

  /**
   * 
   *
   * @return string
   */
  public function getCampaignTrackingFields()
  {
    return $this->campaignTrackingFields;
  }


  /**
   * 
   *
   * @param string $campaignTrackingFields
   *
   * @return $this
   */
  public function setCampaignTrackingFields($campaignTrackingFields)
  {
    $this->campaignTrackingFields = $campaignTrackingFields;
    return $this;
  }

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
