<?php
/**
 * Defines the apiSetAffiliateRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Sets the affiliate of this customer visit. if the sale get processed, the affiliate code and token gets stored   with
 * the order.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiSetAffiliateRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiSetAffiliateRequest.
 */
abstract class apiSetAffiliateRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiSetAffiliate';

  /**
   * the affiliate code
   *
   * @var string
   */
  protected $affiliateCode;

  /**
   * the affiliate token
   *
   * @var string
   */
  protected $affiliateToken;

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * the affiliate code
   *
   * @return string
   */
  public function getAffiliateCode()
  {
    return $this->affiliateCode;
  }


  /**
   * the affiliate code
   *
   * @param string $affiliateCode
   *
   * @return $this
   */
  public function setAffiliateCode($affiliateCode)
  {
    $this->affiliateCode = $affiliateCode;
    return $this;
  }

  /**
   * the affiliate token
   *
   * @return string
   */
  public function getAffiliateToken()
  {
    return $this->affiliateToken;
  }


  /**
   * the affiliate token
   *
   * @param string $affiliateToken
   *
   * @return $this
   */
  public function setAffiliateToken($affiliateToken)
  {
    $this->affiliateToken = $affiliateToken;
    return $this;
  }

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
