<?php
/**
 * Defines the apiGetQuestionnaireDetailsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Returns the details of a given Questionnaire.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetQuestionnaireDetailsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetQuestionnaireDetailsRequest.
 */
abstract class apiGetQuestionnaireDetailsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetQuestionnaireDetails';

  /**
   * The questionnaire to return details for in the form "serverId:questionnaireId"
   *
   * @var string
   */
  protected $questionnaireRef;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The questionnaire to return details for in the form "serverId:questionnaireId"
   *
   * @return string
   */
  public function getQuestionnaireRef()
  {
    return $this->questionnaireRef;
  }


  /**
   * The questionnaire to return details for in the form "serverId:questionnaireId"
   *
   * @param string $questionnaireRef
   *
   * @return $this
   */
  public function setQuestionnaireRef($questionnaireRef)
  {
    $this->questionnaireRef = $questionnaireRef;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
