<?php
/**
 * Defines the apiGetPerformancesBySchemeRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Lists performances for the supplied event which are participating in the supplied schemes.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetPerformancesBySchemeRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetPerformancesBySchemeRequest.
 */
abstract class apiGetPerformancesBySchemeRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetPerformancesByScheme';

  /**
   * The serverId and eventId to list performances for in the form "serverId:eventId"
   *
   * @var string
   */
  protected $eventRef;

  /**
   * a String array of the customers schemes that they're subscribed to. Each element should be a string in the form
   * "serverId:schemeId". If the customer is not loaded then pass in {@code null} instead of an empty array. Also try
   * not to pass in an array with {@code null} elements. This scheme list is then used to include the concessions to
   * which the schemes entitles the customer too.
   *
   * @var string[]
   */
  protected $schemeRefs;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The serverId and eventId to list performances for in the form "serverId:eventId"
   *
   * @return string
   */
  public function getEventRef()
  {
    return $this->eventRef;
  }


  /**
   * The serverId and eventId to list performances for in the form "serverId:eventId"
   *
   * @param string $eventRef
   *
   * @return $this
   */
  public function setEventRef($eventRef)
  {
    $this->eventRef = $eventRef;
    return $this;
  }

  /**
   * a String array of the customers schemes that they're subscribed to. Each element should be a string in the form
   * "serverId:schemeId". If the customer is not loaded then pass in {@code null} instead of an empty array. Also try
   * not to pass in an array with {@code null} elements. This scheme list is then used to include the concessions to
   * which the schemes entitles the customer too.
   *
   * @return string[]
   */
  public function getSchemeRefs()
  {
    return $this->schemeRefs;
  }


  /**
   * a String array of the customers schemes that they're subscribed to. Each element should be a string in the form
   * "serverId:schemeId". If the customer is not loaded then pass in {@code null} instead of an empty array. Also try
   * not to pass in an array with {@code null} elements. This scheme list is then used to include the concessions to
   * which the schemes entitles the customer too.
   *
   * @param string[] $schemeRefs
   *
   * @return $this
   */
  public function setSchemeRefs($schemeRefs)
  {
    $this->schemeRefs = $schemeRefs;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
