<?php
/**
 * Defines the apiGetMyClaimedTicketsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method is used to fetch the details of the items that have been claimed by this customer, defined by  {@code
 * customerId} using {@link #apiClaimFromFriend(java.lang.String, java.lang.String, int, java.lang.String)}
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetMyClaimedTicketsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetMyClaimedTicketsRequest.
 */
abstract class apiGetMyClaimedTicketsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetMyClaimedTickets';

  /**
   * The ID of the customer that has claiming the items.
   *
   * @var int
   */
  protected $customerId;

  /**
   * Whether you want to see tickets from past performances
   *
   * @var bool
   */
  protected $listPastPerformanceTickets;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The ID of the customer that has claiming the items.
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The ID of the customer that has claiming the items.
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * Whether you want to see tickets from past performances
   *
   * @return bool
   */
  public function getListPastPerformanceTickets()
  {
    return $this->listPastPerformanceTickets;
  }


  /**
   * Whether you want to see tickets from past performances
   *
   * @param bool $listPastPerformanceTickets
   *
   * @return $this
   */
  public function setListPastPerformanceTickets($listPastPerformanceTickets)
  {
    $this->listPastPerformanceTickets = $listPastPerformanceTickets;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
