<?php
/**
 * Defines the apiGetDisplayableQuestionnairesRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Returns an array of {@link ViaApiListElement}s representing Questionnaires that are suitable to be displayed to the
 * customer.  OrderId is used to see if any questionnaires are to be fired based on the contents of the order such as a
 * particular event.  If the orderId is null then this information is not used.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetDisplayableQuestionnairesRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetDisplayableQuestionnairesRequest.
 */
abstract class apiGetDisplayableQuestionnairesRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetDisplayableQuestionnaires';

  /**
   * The id of the customer to display the questionnaires to.
   *
   * @var int
   */
  protected $customerId;

  /**
   * The id of the recently completed order, or null.
   *
   * @var int
   */
  protected $orderId;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The id of the customer to display the questionnaires to.
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The id of the customer to display the questionnaires to.
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The id of the recently completed order, or null.
   *
   * @return int
   */
  public function getOrderId()
  {
    return $this->orderId;
  }


  /**
   * The id of the recently completed order, or null.
   *
   * @param int $orderId
   *
   * @return $this
   */
  public function setOrderId($orderId)
  {
    $this->orderId = $orderId;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
