<?php
/**
 * Defines the apiFilterEventsByTimeRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Returns events within a specified time.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiFilterEventsByTimeRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiFilterEventsByTimeRequest.
 */
abstract class apiFilterEventsByTimeRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiFilterEventsByTime';

  /**
   * The starting hour 00-23
   *
   * @var int
   */
  protected $startHour;

  /**
   * The finishing hour 00-23
   *
   * @var int
   */
  protected $endHour;

  /**
   * An array of venue ids to search in the form "serverId:venueId"
   *
   * @var string[]
   */
  protected $venueRefs;

  /**
   * An array of subvenue ids to search in the form "serverId:subvenueId"
   *
   * @var string[]
   */
  protected $subvenueRefs;

  /**
   * An int array of type ids to search
   *
   * @var int[]
   */
  protected $typeIds;

  /**
   * An int array of subtype ids to search
   *
   * @var int[]
   */
  protected $subTypeIds;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The starting hour 00-23
   *
   * @return int
   */
  public function getStartHour()
  {
    return $this->startHour;
  }


  /**
   * The starting hour 00-23
   *
   * @param int $startHour
   *
   * @return $this
   */
  public function setStartHour($startHour)
  {
    $this->startHour = $startHour;
    return $this;
  }

  /**
   * The finishing hour 00-23
   *
   * @return int
   */
  public function getEndHour()
  {
    return $this->endHour;
  }


  /**
   * The finishing hour 00-23
   *
   * @param int $endHour
   *
   * @return $this
   */
  public function setEndHour($endHour)
  {
    $this->endHour = $endHour;
    return $this;
  }

  /**
   * An array of venue ids to search in the form "serverId:venueId"
   *
   * @return string[]
   */
  public function getVenueRefs()
  {
    return $this->venueRefs;
  }


  /**
   * An array of venue ids to search in the form "serverId:venueId"
   *
   * @param string[] $venueRefs
   *
   * @return $this
   */
  public function setVenueRefs($venueRefs)
  {
    $this->venueRefs = $venueRefs;
    return $this;
  }

  /**
   * An array of subvenue ids to search in the form "serverId:subvenueId"
   *
   * @return string[]
   */
  public function getSubvenueRefs()
  {
    return $this->subvenueRefs;
  }


  /**
   * An array of subvenue ids to search in the form "serverId:subvenueId"
   *
   * @param string[] $subvenueRefs
   *
   * @return $this
   */
  public function setSubvenueRefs($subvenueRefs)
  {
    $this->subvenueRefs = $subvenueRefs;
    return $this;
  }

  /**
   * An int array of type ids to search
   *
   * @return int[]
   */
  public function getTypeIds()
  {
    return $this->typeIds;
  }


  /**
   * An int array of type ids to search
   *
   * @param int[] $typeIds
   *
   * @return $this
   */
  public function setTypeIds($typeIds)
  {
    $this->typeIds = $typeIds;
    return $this;
  }

  /**
   * An int array of subtype ids to search
   *
   * @return int[]
   */
  public function getSubTypeIds()
  {
    return $this->subTypeIds;
  }


  /**
   * An int array of subtype ids to search
   *
   * @param int[] $subTypeIds
   *
   * @return $this
   */
  public function setSubTypeIds($subTypeIds)
  {
    $this->subTypeIds = $subTypeIds;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
