<?php
/**
 * Defines the apiCreateInitialUnpaidOrderRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Creates the entire initial order => order record, line items and 'unpaid' payment record.  If this does not return a
 * valid payment Id (greater than ZERO) then DO NOT proceed to  take payment. If this method returns a valid payment Id
 * then it is safe to proceed to take  payment. The result of that payment attempt must be passed to {@link
 * #apiCompleteOrder(int, boolean, String, String, String,String,  String, String, String, String, String)} to complete
 * the order. If the payment fails then this method can be called again  and will persist the new unpaid payment against
 * the original for processing. Remember to only proceed to payment if this method returns  a valid paymentId (greater
 * than ZERO).
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiCreateInitialUnpaidOrderRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiCreateInitialUnpaidOrderRequest.
 */
abstract class apiCreateInitialUnpaidOrderRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiCreateInitialUnpaidOrder';

  /**
   * the card holder's name
   *
   * @var string
   */
  protected $ccName;

  /**
   * the Primary Account CARD Number without spaces
   *
   * @var string
   */
  protected $ccNumber;

  /**
   * start date of the form "MM/YY" if available
   *
   * @var string
   */
  protected $startDate;

  /**
   * expiry date of the form "MM/YY" if available
   *
   * @var string
   */
  protected $expiryDate;

  /**
   * issue number if available
   *
   * @var string
   */
  protected $issue;

  /**
   * the webserver hostname making this payment if available
   *
   * @var string
   */
  protected $workstationId;

  /**
   * <code>0</code> to indicate that the order will be collected at the box office, <code>1</code> to indicate that the
   * tickets will be posted out to the customers primary address, <code>2</code> to indicate that the tickets will be
   * posted to the customers alternative address.
   *
   * @var int
   */
  protected $deliveryOption;

  /**
   * ID representing the customer making this payment
   *
   * @var int
   */
  protected $customerId;

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * the card holder's name
   *
   * @return string
   */
  public function getCcName()
  {
    return $this->ccName;
  }


  /**
   * the card holder's name
   *
   * @param string $ccName
   *
   * @return $this
   */
  public function setCcName($ccName)
  {
    $this->ccName = $ccName;
    return $this;
  }

  /**
   * the Primary Account CARD Number without spaces
   *
   * @return string
   */
  public function getCcNumber()
  {
    return $this->ccNumber;
  }


  /**
   * the Primary Account CARD Number without spaces
   *
   * @param string $ccNumber
   *
   * @return $this
   */
  public function setCcNumber($ccNumber)
  {
    $this->ccNumber = $ccNumber;
    return $this;
  }

  /**
   * start date of the form "MM/YY" if available
   *
   * @return string
   */
  public function getStartDate()
  {
    return $this->startDate;
  }


  /**
   * start date of the form "MM/YY" if available
   *
   * @param string $startDate
   *
   * @return $this
   */
  public function setStartDate($startDate)
  {
    $this->startDate = $startDate;
    return $this;
  }

  /**
   * expiry date of the form "MM/YY" if available
   *
   * @return string
   */
  public function getExpiryDate()
  {
    return $this->expiryDate;
  }


  /**
   * expiry date of the form "MM/YY" if available
   *
   * @param string $expiryDate
   *
   * @return $this
   */
  public function setExpiryDate($expiryDate)
  {
    $this->expiryDate = $expiryDate;
    return $this;
  }

  /**
   * issue number if available
   *
   * @return string
   */
  public function getIssue()
  {
    return $this->issue;
  }


  /**
   * issue number if available
   *
   * @param string $issue
   *
   * @return $this
   */
  public function setIssue($issue)
  {
    $this->issue = $issue;
    return $this;
  }

  /**
   * the webserver hostname making this payment if available
   *
   * @return string
   */
  public function getWorkstationId()
  {
    return $this->workstationId;
  }


  /**
   * the webserver hostname making this payment if available
   *
   * @param string $workstationId
   *
   * @return $this
   */
  public function setWorkstationId($workstationId)
  {
    $this->workstationId = $workstationId;
    return $this;
  }

  /**
   * <code>0</code> to indicate that the order will be collected at the box office, <code>1</code> to indicate that the
   * tickets will be posted out to the customers primary address, <code>2</code> to indicate that the tickets will be
   * posted to the customers alternative address.
   *
   * @return int
   */
  public function getDeliveryOption()
  {
    return $this->deliveryOption;
  }


  /**
   * <code>0</code> to indicate that the order will be collected at the box office, <code>1</code> to indicate that the
   * tickets will be posted out to the customers primary address, <code>2</code> to indicate that the tickets will be
   * posted to the customers alternative address.
   *
   * @param int $deliveryOption
   *
   * @return $this
   */
  public function setDeliveryOption($deliveryOption)
  {
    $this->deliveryOption = $deliveryOption;
    return $this;
  }

  /**
   * ID representing the customer making this payment
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * ID representing the customer making this payment
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
