<?php
/**
 * Defines the apiAddDonationToBasketRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Add a donation of any positive amount to the basket. Use this call to update a donation value.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiAddDonationToBasketRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiAddDonationToBasketRequest.
 */
abstract class apiAddDonationToBasketRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiAddDonationToBasket';

  /**
   * 
   *
   * @var string
   */
  protected $donationFundRef;

  /**
   * The amount of the donation
   *
   * @var double
   */
  protected $amount;

  /**
   * The ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * 
   *
   * @return string
   */
  public function getDonationFundRef()
  {
    return $this->donationFundRef;
  }


  /**
   * 
   *
   * @param string $donationFundRef
   *
   * @return $this
   */
  public function setDonationFundRef($donationFundRef)
  {
    $this->donationFundRef = $donationFundRef;
    return $this;
  }

  /**
   * The amount of the donation
   *
   * @return double
   */
  public function getAmount()
  {
    return $this->amount;
  }


  /**
   * The amount of the donation
   *
   * @param double $amount
   *
   * @return $this
   */
  public function setAmount($amount)
  {
    $this->amount = $amount;
    return $this;
  }

  /**
   * The ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * The ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
