<?php
/**
 * Defines ViaPluginManager
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\Plugin;
use string;

/**
 * A ViaPluginManager handles all event notifications from the Via API client. It is used instead of
 * a third-party event dispatcher to avoid dependencies, but end-users may wish to implement event
 * dispatch that integrates with their own application.
 *
 * Custom event dispatchers will need to satisfy the ViaPluginManager interface, listeners will need
 * to implement ViaPluginInterface and any events dispatched will need to satisfy the ViaPluginNotification
 * interface.
 *
 * @package Red61\Via\Plugin
 */
interface ViaPluginManager {

	/**
	 * Called when plugins should receive an event notification
	 *
	 * @param \Red61\Via\Plugin\ViaPluginNotification $notification
	 *
	 * @return mixed
	 */
	public function notify(ViaPluginNotification $notification);

	/**
	 * Register a plugin to receive notifications. Optionally, pass a list of notifications to receive.
	 *
	 * @param ViaPluginInterface $plugin
	 * @param string[]           $only_notifications a list of the notification names you wish to receive, or NULL to receive all.
	 *
	 * @return $this
	 */
	public function registerPlugin(ViaPluginInterface $plugin, $only_notifications = NULL);
}
