<?php
/**
 * Defines the ViaApiAddressDetails VIA data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\DataObject;

/**
 * @package    Red61\Via\DataObject
 * {@inheritdoc}
 */
class ViaApiAddressDetails extends \Red61\Via\RawGenerated\DataObject\ViaApiAddressDetails {

	/**
	 * Optionally populate the address fields when creating an instance - for example, in order to
	 * pass the address details object as a search parameter in a apiAddressSearch request.
	 *
	 * [!!] This constructor is not called when the object is created as part of an API response.
	 *
	 * @param string $address1
	 * @param string $address2
	 * @param string $address3
	 * @param string $county
	 * @param string $country
	 * @param string $postcode
	 */
	public function __construct($address1 = NULL, $address2 = NULL, $address3 = NULL, $county = NULL, $country = NULL, $postcode = NULL)
	{
		$this->address1 = $address1;
		$this->address2 = $address2;
		$this->address3 = $address3;
		$this->county   = $county;
		$this->country  = $country;
		$this->postcode = $postcode;
	}
}
