<?php
/**
 * Holds the default VIA cache TTL configuration
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\Cache;


/**
 * This class holds the default cache TTL configuration - it may be autogenerated in future
 *
 * To customise TTL for your own application, see the constructor options for the ViaCachePlugin.
 *
 * @package Red61\Via\Cache
 */
class ViaCacheTTLConfig {

	/**
	 * @var int[] default ttl for methods, as an array by SOAP method name
	 */
	public static $default_ttl = array(
		'apiGetEvents'                         => 3600,
		'apiGetCustomerCategories'             => 0,
		'apisetCustomerCategories'             => 0,
		'apiGetPostageCharges'                 => 3600,
		'apiSetPostageCharge'                  => 0,
		'apiCleanUnpaidOrder'                  => 0,
		'apiCreateGiftAidDeclaration'          => 0,
		'apiGetPerformances'                   => 1800,
		'apiGetPerformancesByScheme'           => 1800,
		'apiGetPerformancePrices'              => 1800,
		'apiGetPerformanceAvailibility'        => 0,
		'apiGetPerformanceAvailibilityList'    => 0,
		'apiGetPriceBandAvailability'          => 0,
		'apiGetEventDetails'                   => 1800,
		'apiGetDonationsForEvent'              => 1800,
		'apiGetPerformanceDetails'             => 1800,
		'apiCreateAccount'                     => 0,
		'apiUpdateCustomerOtherDetails'        => 0,
		'apiSetCreateGiftAidDeclaration'       => 0,
		'apiAddSchemeToBasket'                 => 0,
		'apiRemoveSchemeFromBasket'            => 0,
		'apiGetCustomerVouchers'               => 0,
		'apiGetVoucherTypes'                   => 3600,
		'apiAddVoucherTypeToBasket'            => 0,
		'apiRemoveVoucherTypeFromBasket'       => 0,
		'apiRemoveVoucherTypesFromBasket'      => 0,
		'apiRedeemVoucher'                     => 0,
		'apiRemoveVoucherRedeemFromBasket'     => 0,
		'apiRemoveVoucherRedeemsFromBasket'    => 0,
		'apiGetVoucherRedeemsFromBasket'       => 0,
		'apiGetMerchandiseCategories'          => 3600,
		'apiGetMerchandise'                    => 3600,
		'apiGetMerchandiseByCategory'          => 3600,
		'apiAddMerchandiseToBasket'            => 0,
		'apiRemoveMerchandiseFromBasket'       => 0,
		'apiAddDonationToBasket'               => 0,
		'apiRemoveDonationFromBasket'          => 0,
		'apiGetDonationFunds'                  => 3600,
		'apiGetSchemeDetails'                  => 3600,
		'apiGetCustomerSchemes'                => 0,
		'apiGetSchemeTierDetails'              => 3600,
		'apiAddTicketsToBasket'                => 0,
		'apiUpdateTicketConcession'            => 0,
		'apiGetBasketItems'                    => 0,
		'apiSetBasketCustomer'                 => 0,
		'apiGetGiftAidText'                    => 3600,
		'apiGetBasketSummary'                  => 0,
		'apiGetBasketSuggestedDonations'       => 0,
		'apiSendConfirmationEmail'             => 0,
		'apiClearBasket'                       => 0,
		'apiRemoveTicket'                      => 0,
		'apiLogin'                             => 0,
		'apiGetCustomerName'                   => 0,
		'apiGetVenues'                         => 3600,
		'apiGetSubVenues'                      => 3600,
		'apiGetVenueDetails'                   => 3600,
		'apiGetSubVenueDetails'                => 3600,
		'apiGetSchemes'                        => 3600,
		'apiGetEventTypes'                     => 3600,
		'apiGetArtists'                        => 3600,
		'apiFilterEvents'                      => 900,
		'apiFilterEventsByTime'                => 900,
		'apiGetCustomerSavedCards'             => 0,
		'apiCreateOrder'                       => 0,
		'apiCreateInitialUnpaidOrder'          => 0,
		'apiCompleteOrder'                     => 0,
		'apiCreateUnpaidAccountOrder'          => 0,
		'apiCompleteAccountOrder'              => 0,
		'apiCreateReservation'                 => 0,
		'apiCreateRepeatPaymentOrder'          => 0,
		'apiSetAffiliate'                      => 0,
		'apiSetCampaignTrackingId'             => 0,
		'apiSend3DSecureReturn'                => 0,
		'apiGetOrderSummary'                   => 0,
		'apiGetCustomerTransactions'           => 0,
		'apiGetCustomerTransactionsSummary'    => 0,
		'apiIsPostAllowed'                     => 0,
		'apiSetCustomerFriendStatus'           => 0,
		'apiGetCustomerFriendStatus'           => 0,
		'apiGetCustomerDetails'                => 0,
		'apiEventQuickSearch'                  => 900,
		'apiEventDetailedSearch'               => 900,
		'apiGetCountries'                      => 3600,
		'apiGetCountryDetails'                 => 3600,
		'apiSearchAddress'                     => 3600,
		'apiGetAddress'                        => 3600,
		'apiCustomerPasswordReset'             => 0,
		'apiGetSeatingPlan'                    => 5,
		'apiGetDisplayableQuestionnaires'      => 0,
		'apiGetQuestionnaireDetails'           => 0,
		'apiDeclineQuestionnaire'              => 0,
		'apiAnswerQuestionnaire'               => 0,
		'apiGetCustomCustomerFields'           => 0,
		'apiGetEventTags'                      => 3600,
		'apiGetBasketLimits'                   => 10,
		'apiUpdateCustomerCustomFields'        => 0,
		'apiGetBasketSessionId'                => 0,
		'apiRegisterInterestInEvent'           => 0,
		'apiRegisterInterestInPerformance'     => 0,
		'apiGetCustomerInterestsEvent'         => 0,
		'apiGetCustomerInterestsPerformance'   => 0,
		'apiGetCustomersByEventInterest'       => 0,
		'apiGetCustomersByPerformanceInterest' => 0,
		'apiSendToAFriend'                     => 0,
		'apiClaimFromFriend'                   => 0,
		'apiGetTicketsByClaimToken'            => 0,
		'apiGetMyClaimedTickets'               => 0,
		'apiaddPromocodeToBasket'              => 0,
	);
} 
