<?php
/**
 * Defines the apiGetBasketSummaryRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\ApiRequest;
use Red61\Via\DataObject\ViaApiBasketSummary;
use Red61\Via\Plugin\ViaApiCallNotification;

/**
 * @package    Red61\Via\ApiRequest
 * {@inheritdoc}
 */
class apiGetBasketSummaryRequest
	extends \Red61\Via\RawGenerated\ApiRequest\apiGetBasketSummaryRequest
	implements PreflightFilteringRequest {

	/**
	 * Sets a canned empty basket items summary if the basket ID has not yet been set
	 * {@inheritdoc}
	 */
	public function onBeforeViaCall(ViaApiCallNotification $notification)
	{
		if ( ! $this->getSessionId()) {
			$notification->skipCallAndReturn(new ViaApiBasketSummary);
		}
	}

}
