<?php
/**
 * Defines the apiCreateAccountRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\ApiRequest;
use Red61\Via\Exception\ClientInvalidRequestException;
use Red61\Via\Plugin\ViaApiCallNotification;

/**
 * @package    Red61\Via\ApiRequest
 * {@inheritdoc}
 */
class apiCreateAccountRequest
	extends \Red61\Via\RawGenerated\ApiRequest\apiCreateAccountRequest
	implements PreflightFilteringRequest {

	/**
	 * Perform some action - validation, canned response or initialisation - immediately before the request is sent
	 *
	 * @param ViaApiCallNotification $notification
	 *
	 * @throws \Red61\Via\Exception\ClientInvalidRequestException
	 * @return void
	 */
	public function onBeforeViaCall(ViaApiCallNotification $notification)
	{
		$errors = $this->buildEmptyFieldErrorsFor(array('forename', 'surname', 'email'));

		$create  = $this->getCreate();
		$cust_id = $this->getCustomerId();

		if ($create AND ($cust_id !== 0)) {
			$errors['customerId'] = 'You must set customerId to 0 to create a new account';
		} else if ( ! $create AND ! $cust_id) {
			$errors['customerId'] = 'You must set customerId to update a customer account';
		}

		if (strlen($this->getSurname()) < 2) {
			$errors['surname'] = 'Surname must be at least two characters';
		}

		if ($errors) {
			throw new ClientInvalidRequestException($this, $errors);
		}
	}

	/**
	 * Trims the value before setting
	 *
	 * {@inheritdoc}
	 */
	public function setPreferredContactMethod($preferredContactMethod)
	{
		return parent::setPreferredContactMethod(trim($preferredContactMethod));
	}

	/**
	 * Trims the value before setting
	 *
	 * {@inheritdoc}
	 */
	public function setEmail($email)
	{
		return parent::setEmail(trim($email));
	}

	/**
	 * Trims the value before setting
	 *
	 * {@inheritdoc}
	 */
	public function setForename($forename)
	{
		return parent::setForename(trim($forename));
	}

	/**
	 * Trims the value before setting
	 *
	 * {@inheritdoc}
	 */
	public function setSurname($surname)
	{
		return parent::setSurname(trim($surname));
	}

}
