<?php
/**
 * Defines the LazyBasketMetadataSettingRequest interface
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\ApiRequest;

/**
 * A LazyBasketMetadataSettingRequest will be sent immediately by the ViaApiClient if a basket has already
 * been created when the request is sent. Otherwise, it will be deferred and sent if a basket is created
 * later.
 *
 * This is used to handle calls like setCampaignTrackingId so that they can be called high up in the
 * application - for example in a dispatcher or base controller - where affiliate cookies or referrers
 * may be available.
 *
 * [!!] These requests are only deferred for the current request execution. If you need to track eg an
 *      affiliate through multiple pageloads before a basket is eventually requested you will need to
 *      persist this through your own session management.
 *
 * [!!] This should only be used with requests that return void - it obviously makes no sense to use
 *      if the calling code may need to check for a return value.
 *
 * @package Red61\Via\ApiRequest
 */
interface LazyBasketMetadataSettingRequest {

}
