<?php
/**
 * Defines ViaExceptionMapperSpec - specifications for Red61\Via\Exception\ViaExceptionMapper
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\Exception;

use Red61\Via\ViaClassmap;
use spec\ObjectBehavior;
use Prophecy\Argument;

/**
 *
 * @see Red61\Via\Exception\ViaExceptionMapper
 */
class ViaExceptionMapperSpec extends ObjectBehavior
{
    /**
     * Use $this->subject to get proper type hinting for the subject class
     * @var \Red61\Via\Exception\ViaExceptionMapper
     */
	protected $subject;

	function it_is_initializable()
    {
		$this->subject->shouldHaveType('Red61\Via\Exception\ViaExceptionMapper');
	}

	function it_maps_expected_exception_to_defined_via_type()
	{
		$detail = new \stdClass;
		$detail->CartNotFoundException = "";
		$fault = new \SoapFault('soap:Server', 'Basket Expired', NULL, $detail);

		$this->subject->map($fault)->shouldReturnClassNamed(ViaClassmap::$exceptionClassmap['CartNotFoundException']);
	}

	function it_maps_to_invalid_mapping_exception_if_mapped_type_does_not_exist()
	{
		$this->beConstructedWith(array('CartNotFoundException' => '\A\Random\Nonexistent\Class'));

		$detail = new \stdClass;
		$detail->CartNotFoundException = "";
		$fault = new \SoapFault('soap:Server', 'Basket Expired', NULL, $detail);

		$this->subject->map($fault)->shouldReturnClassNamed('\Red61\Via\Exception\InvalidExceptionMappingException');
	}

	function it_maps_to_generic_exception_if_exception_type_not_in_classmap()
	{
		$detail = new \stdClass;
		$detail->SomeRandomException = "";
		$fault = new \SoapFault('soap:Server', 'Bad Gateway', NULL, $detail);

		$this->subject->map($fault)->shouldReturnClassNamed(ViaClassmap::$exceptionClassmap['_generic']);
	}

	function it_maps_to_generic_exception_if_detail_is_not_an_object()
	{
		$fault = new \SoapFault('soap:Server', 'Bad Gateway', NULL, "not a detail object");
		$this->subject->map($fault)->shouldReturnClassNamed(ViaClassmap::$exceptionClassmap['_generic']);
	}

	function it_maps_to_generic_exception_if_detail_has_multiple_fields()
	{
		$details = new \stdClass;
		$details->CartNotFoundException   = "";
		$details->CustomerMergedException = "";
		$fault = new \SoapFault('soap:Server', 'Bad Gateway', NULL, "not a detail object");

		$this->subject->map($fault)->shouldReturnClassNamed(ViaClassmap::$exceptionClassmap['_generic']);
	}

	function it_maps_to_generic_exception_if_detail_is_not_set()
	{
		$fault = new \SoapFault('soap:Server', 'Bad Gateway');
		$this->subject->map($fault)->shouldReturnClassNamed(ViaClassmap::$exceptionClassmap['_generic']);
	}

	function it_transfers_message_to_mapped_exception()
	{
		$fault = new \SoapFault('soap:Server', 'Bad Gateway');
		$this->subject->map($fault)->getMessage()->shouldMatch('/Bad Gateway/');
	}

	function it_transfers_detail_to_mapped_exception()
	{
		$detail = new \stdClass;
		$detail->CartNotFoundException = "";
		$fault = new \SoapFault('soap:Server', 'Bad Gateway', NULL, $detail);
		$this->subject->map($fault)->detail->shouldBe($detail);
	}

	function it_transfers_faultcode_to_mapped_exception()
	{
		$fault = new \SoapFault('soap:Server', 'Bad Gateway');
		$this->subject->map($fault)->faultcode->shouldBe('soap:Server');
	}

	function getMatchers()
	{
		$matchers = parent::getMatchers();

		$matchers['returnClassNamed'] = function ($argument, $expected) {
			return (get_class($argument) === trim($expected, '\\'));
		};
		return $matchers;
	}


}
